/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.apache.activemq.transport.mqtt.MQTTRetainedMessages;
import org.apache.activemq.transport.mqtt.ResponseHandler;
import org.fusesource.mqtt.codec.PUBLISH;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PublishResponseHandler
implements ResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PublishResponseHandler.class);
    PUBLISH command;
    ActiveMQMessage message;
    MQTTRetainedMessages retainedMessages;

    protected PublishResponseHandler(PUBLISH command, ActiveMQMessage message, MQTTRetainedMessages retainedMessages) {
        this.command = command;
        this.message = message;
        this.retainedMessages = retainedMessages;
    }

    @Override
    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
        if (response.isException()) {
            LOG.warn("Failed to send MQTT Publish: ", (Object)this.command, (Object)((ExceptionResponse)response).getException());
        } else if (this.command.retain()) {
            this.retainedMessages.addMessage((ActiveMQTopic)this.message.getDestination(), this.command);
        }
        this.sendACK();
    }

    public abstract void sendACK() throws IOException;
}

