/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.util.Assert;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractMarshaller
implements Marshaller,
Unmarshaller {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean processExternalEntities = false;
    private DocumentBuilderFactory documentBuilderFactory;
    private final Object documentBuilderFactoryMonitor = new Object();
    private static final EntityResolver NO_OP_ENTITY_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    };

    public void setProcessExternalEntities(boolean processExternalEntities) {
        this.processExternalEntities = processExternalEntities;
    }

    public boolean isProcessExternalEntities() {
        return this.processExternalEntities;
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        return factory;
    }

    protected DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        return factory.newDocumentBuilder();
    }

    protected XMLReader createXmlReader() throws SAXException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", this.isProcessExternalEntities());
        if (!this.isProcessExternalEntities()) {
            xmlReader.setEntityResolver(NO_OP_ENTITY_RESOLVER);
        }
        return xmlReader;
    }

    protected String getDefaultEncoding() {
        return null;
    }

    public final void marshal(Object graph, Result result) throws IOException, XmlMappingException {
        if (result instanceof DOMResult) {
            this.marshalDomResult(graph, (DOMResult)result);
        } else if (StaxUtils.isStaxResult((Result)result)) {
            this.marshalStaxResult(graph, result);
        } else if (result instanceof SAXResult) {
            this.marshalSaxResult(graph, (SAXResult)result);
        } else if (result instanceof StreamResult) {
            this.marshalStreamResult(graph, (StreamResult)result);
        } else {
            throw new IllegalArgumentException("Unknown Result type: " + result.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void marshalDomResult(Object graph, DOMResult domResult) throws XmlMappingException {
        if (domResult.getNode() == null) {
            try {
                Object object = this.documentBuilderFactoryMonitor;
                synchronized (object) {
                    if (this.documentBuilderFactory == null) {
                        this.documentBuilderFactory = this.createDocumentBuilderFactory();
                    }
                }
                DocumentBuilder documentBuilder = this.createDocumentBuilder(this.documentBuilderFactory);
                domResult.setNode(documentBuilder.newDocument());
            }
            catch (ParserConfigurationException ex) {
                throw new UnmarshallingFailureException("Could not create document placeholder for DOMResult: " + ex.getMessage(), ex);
            }
        }
        this.marshalDomNode(graph, domResult.getNode());
    }

    protected void marshalStaxResult(Object graph, Result staxResult) throws XmlMappingException {
        XMLStreamWriter streamWriter = StaxUtils.getXMLStreamWriter((Result)staxResult);
        if (streamWriter != null) {
            this.marshalXmlStreamWriter(graph, streamWriter);
        } else {
            XMLEventWriter eventWriter = StaxUtils.getXMLEventWriter((Result)staxResult);
            if (eventWriter != null) {
                this.marshalXmlEventWriter(graph, eventWriter);
            } else {
                throw new IllegalArgumentException("StaxResult contains neither XMLStreamWriter nor XMLEventConsumer");
            }
        }
    }

    protected void marshalSaxResult(Object graph, SAXResult saxResult) throws XmlMappingException {
        ContentHandler contentHandler = saxResult.getHandler();
        Assert.notNull((Object)contentHandler, (String)"ContentHandler not set on SAXResult");
        LexicalHandler lexicalHandler = saxResult.getLexicalHandler();
        this.marshalSaxHandlers(graph, contentHandler, lexicalHandler);
    }

    protected void marshalStreamResult(Object graph, StreamResult streamResult) throws XmlMappingException, IOException {
        if (streamResult.getOutputStream() != null) {
            this.marshalOutputStream(graph, streamResult.getOutputStream());
        } else if (streamResult.getWriter() != null) {
            this.marshalWriter(graph, streamResult.getWriter());
        } else {
            throw new IllegalArgumentException("StreamResult contains neither OutputStream nor Writer");
        }
    }

    public final Object unmarshal(Source source) throws IOException, XmlMappingException {
        if (source instanceof DOMSource) {
            return this.unmarshalDomSource((DOMSource)source);
        }
        if (StaxUtils.isStaxSource((Source)source)) {
            return this.unmarshalStaxSource(source);
        }
        if (source instanceof SAXSource) {
            return this.unmarshalSaxSource((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.unmarshalStreamSource((StreamSource)source);
        }
        throw new IllegalArgumentException("Unknown Source type: " + source.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unmarshalDomSource(DOMSource domSource) throws XmlMappingException {
        if (domSource.getNode() == null) {
            try {
                Object object = this.documentBuilderFactoryMonitor;
                synchronized (object) {
                    if (this.documentBuilderFactory == null) {
                        this.documentBuilderFactory = this.createDocumentBuilderFactory();
                    }
                }
                DocumentBuilder documentBuilder = this.createDocumentBuilder(this.documentBuilderFactory);
                domSource.setNode(documentBuilder.newDocument());
            }
            catch (ParserConfigurationException ex) {
                throw new UnmarshallingFailureException("Could not create document placeholder for DOMSource: " + ex.getMessage(), ex);
            }
        }
        return this.unmarshalDomNode(domSource.getNode());
    }

    protected Object unmarshalStaxSource(Source staxSource) throws XmlMappingException {
        XMLStreamReader streamReader = StaxUtils.getXMLStreamReader((Source)staxSource);
        if (streamReader != null) {
            return this.unmarshalXmlStreamReader(streamReader);
        }
        XMLEventReader eventReader = StaxUtils.getXMLEventReader((Source)staxSource);
        if (eventReader != null) {
            return this.unmarshalXmlEventReader(eventReader);
        }
        throw new IllegalArgumentException("StaxSource contains neither XMLStreamReader nor XMLEventReader");
    }

    protected Object unmarshalSaxSource(SAXSource saxSource) throws XmlMappingException, IOException {
        if (saxSource.getXMLReader() == null) {
            try {
                saxSource.setXMLReader(this.createXmlReader());
            }
            catch (SAXException ex) {
                throw new UnmarshallingFailureException("Could not create XMLReader for SAXSource", ex);
            }
        }
        if (saxSource.getInputSource() == null) {
            saxSource.setInputSource(new InputSource());
        }
        return this.unmarshalSaxReader(saxSource.getXMLReader(), saxSource.getInputSource());
    }

    protected Object unmarshalStreamSource(StreamSource streamSource) throws XmlMappingException, IOException {
        if (streamSource.getInputStream() != null) {
            if (this.isProcessExternalEntities()) {
                return this.unmarshalInputStream(streamSource.getInputStream());
            }
            InputSource inputSource = new InputSource(streamSource.getInputStream());
            inputSource.setEncoding(this.getDefaultEncoding());
            return this.unmarshalSaxSource(new SAXSource(inputSource));
        }
        if (streamSource.getReader() != null) {
            if (this.isProcessExternalEntities()) {
                return this.unmarshalReader(streamSource.getReader());
            }
            return this.unmarshalSaxSource(new SAXSource(new InputSource(streamSource.getReader())));
        }
        return this.unmarshalSaxSource(new SAXSource(new InputSource(streamSource.getSystemId())));
    }

    protected abstract void marshalDomNode(Object var1, Node var2) throws XmlMappingException;

    protected abstract void marshalXmlEventWriter(Object var1, XMLEventWriter var2) throws XmlMappingException;

    protected abstract void marshalXmlStreamWriter(Object var1, XMLStreamWriter var2) throws XmlMappingException;

    protected abstract void marshalSaxHandlers(Object var1, ContentHandler var2, LexicalHandler var3) throws XmlMappingException;

    protected abstract void marshalOutputStream(Object var1, OutputStream var2) throws XmlMappingException, IOException;

    protected abstract void marshalWriter(Object var1, Writer var2) throws XmlMappingException, IOException;

    protected abstract Object unmarshalDomNode(Node var1) throws XmlMappingException;

    protected abstract Object unmarshalXmlEventReader(XMLEventReader var1) throws XmlMappingException;

    protected abstract Object unmarshalXmlStreamReader(XMLStreamReader var1) throws XmlMappingException;

    protected abstract Object unmarshalSaxReader(XMLReader var1, InputSource var2) throws XmlMappingException, IOException;

    protected abstract Object unmarshalInputStream(InputStream var1) throws XmlMappingException, IOException;

    protected abstract Object unmarshalReader(Reader var1) throws XmlMappingException, IOException;
}

