/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring3.xml.encryption;

import org.jasypt.spring3.properties.EncryptablePropertyPlaceholderConfigurer;
import org.jasypt.spring3.xml.encryption.AbstractEncryptablePropertyLoadingBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EncryptablePropertyPlaceholderBeanDefinitionParser
extends AbstractEncryptablePropertyLoadingBeanDefinitionParser {
    private static final String ENCRYPTOR_ATTRIBUTE = "encryptor";

    EncryptablePropertyPlaceholderBeanDefinitionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return EncryptablePropertyPlaceholderConfigurer.class;
    }

    @Override
    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        String encryptorBeanName;
        super.doParse(element, builder);
        builder.addPropertyValue("ignoreUnresolvablePlaceholders", (Object)Boolean.valueOf(element.getAttribute("ignore-unresolvable")));
        String systemPropertiesModeName = element.getAttribute("system-properties-mode");
        if (StringUtils.hasLength((String)systemPropertiesModeName)) {
            builder.addPropertyValue("systemPropertiesModeName", (Object)("SYSTEM_PROPERTIES_MODE_" + systemPropertiesModeName));
        }
        if (StringUtils.hasText((String)(encryptorBeanName = element.getAttribute(ENCRYPTOR_ATTRIBUTE)))) {
            builder.addConstructorArgReference(encryptorBeanName);
        }
    }
}

