/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.leveldb.replicated;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.activemq.leveldb.LevelDBClient$;
import org.apache.activemq.leveldb.util.FileSupport$;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import scala.Function1;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sun.nio.ch.DirectBuffer;

public final class ReplicationSupport$
implements ScalaObject {
    public static final ReplicationSupport$ MODULE$;
    private final AsciiBuffer WAL_ACTION;
    private final AsciiBuffer LOGIN_ACTION;
    private final AsciiBuffer SYNC_ACTION;
    private final AsciiBuffer GET_ACTION;
    private final AsciiBuffer ACK_ACTION;
    private final AsciiBuffer OK_ACTION;
    private final AsciiBuffer DISCONNECT_ACTION;
    private final AsciiBuffer ERROR_ACTION;
    private final AsciiBuffer LOG_DELETE_ACTION;

    static {
        new ReplicationSupport$();
    }

    public AsciiBuffer WAL_ACTION() {
        return this.WAL_ACTION;
    }

    public AsciiBuffer LOGIN_ACTION() {
        return this.LOGIN_ACTION;
    }

    public AsciiBuffer SYNC_ACTION() {
        return this.SYNC_ACTION;
    }

    public AsciiBuffer GET_ACTION() {
        return this.GET_ACTION;
    }

    public AsciiBuffer ACK_ACTION() {
        return this.ACK_ACTION;
    }

    public AsciiBuffer OK_ACTION() {
        return this.OK_ACTION;
    }

    public AsciiBuffer DISCONNECT_ACTION() {
        return this.DISCONNECT_ACTION;
    }

    public AsciiBuffer ERROR_ACTION() {
        return this.ERROR_ACTION;
    }

    public AsciiBuffer LOG_DELETE_ACTION() {
        return this.LOG_DELETE_ACTION;
    }

    public void unmap(MappedByteBuffer buffer) {
        try {
            ((DirectBuffer)((Object)buffer)).cleaner().clean();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public MappedByteBuffer map(File file, long offset, long length, boolean readOnly) {
        RandomAccessFile raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
        MappedByteBuffer exceptionResult1 = null;
        try {
            FileChannel.MapMode mode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            exceptionResult1 = raf.getChannel().map(mode, offset, length);
            return exceptionResult1;
        }
        finally {
            raf.close();
        }
    }

    public void stash(File directory) {
        directory.mkdirs();
        File tmp_stash = FileSupport$.MODULE$.toRichFile(directory).$div("stash.tmp");
        File stash = FileSupport$.MODULE$.toRichFile(directory).$div("stash");
        FileSupport$.MODULE$.toRichFile(stash).recursiveDelete();
        FileSupport$.MODULE$.toRichFile(tmp_stash).recursiveDelete();
        tmp_stash.mkdirs();
        this.copy_store_dir(directory, tmp_stash);
        tmp_stash.renameTo(stash);
    }

    public void copy_store_dir(File from, File to$1) {
        Object object;
        TreeMap<Object, File> log_files = LevelDBClient$.MODULE$.find_sequence_files(from, ".log");
        if (log_files.isEmpty()) {
            object = BoxedUnit.UNIT;
        } else {
            File append_file$1 = (File)((Tuple2)log_files.last())._2();
            log_files.values().withFilter((Function1)new Serializable(append_file$1){
                public static final long serialVersionUID;
                private final File append_file$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File file) {
                    File file2 = file;
                    File file3 = this.append_file$1;
                    return file2 != null ? !((Object)file2).equals(file3) : file3 != null;
                }
                {
                    this.append_file$1 = file;
                }
            }).foreach((Function1)new Serializable(to$1){
                public static final long serialVersionUID;
                private final File to$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(File file) {
                    FileSupport$.MODULE$.toRichFile(file).linkTo(FileSupport$.MODULE$.toRichFile(this.to$1).$div(file.getName()));
                    File crc_file = FileSupport$.MODULE$.toRichFile(file.getParentFile()).$div(new StringBuilder().append((Object)file.getName()).append((Object)".crc32").toString());
                    if (crc_file.exists()) {
                        FileSupport$.MODULE$.toRichFile(crc_file).linkTo(FileSupport$.MODULE$.toRichFile(this.to$1).$div(crc_file.getName()));
                    }
                }
                {
                    this.to$1 = file;
                }
            });
            object = BoxesRunTime.boxToLong((long)FileSupport$.MODULE$.toRichFile(append_file$1).copyTo(FileSupport$.MODULE$.toRichFile(to$1).$div(append_file$1.getName())));
        }
        TreeMap<Object, File> index_dirs = LevelDBClient$.MODULE$.find_sequence_files(from, ".index");
        if (!index_dirs.isEmpty()) {
            File index_file = (File)((Tuple2)index_dirs.last())._2();
            File target = FileSupport$.MODULE$.toRichFile(to$1).$div(index_file.getName());
            target.mkdirs();
            LevelDBClient$.MODULE$.copyIndex(index_file, target);
        }
    }

    public void stash_clear(File directory) {
        File stash = FileSupport$.MODULE$.toRichFile(directory).$div("stash");
        FileSupport$.MODULE$.toRichFile(stash).recursiveDelete();
    }

    public void unstash(File directory) {
        File tmp_stash = FileSupport$.MODULE$.toRichFile(directory).$div("stash.tmp");
        FileSupport$.MODULE$.toRichFile(tmp_stash).recursiveDelete();
        File stash = FileSupport$.MODULE$.toRichFile(directory).$div("stash");
        if (stash.exists()) {
            this.delete_store(directory);
            this.copy_store_dir(stash, directory);
            FileSupport$.MODULE$.toRichFile(stash).recursiveDelete();
        }
    }

    public void delete_store(File directory$1) {
        TreeMap<Object, File> t = LevelDBClient$.MODULE$.find_sequence_files(directory$1, ".log");
        t.foreach((Function1)new Serializable(directory$1){
            public static final long serialVersionUID;
            private final File directory$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(Tuple2<Object, File> entry) {
                File file = (File)entry._2();
                file.delete();
                File crc_file = FileSupport$.MODULE$.toRichFile(this.directory$1).$div(new StringBuilder().append((Object)file.getName()).append((Object)".crc32").toString());
                return crc_file.exists() ? BoxesRunTime.boxToBoolean((boolean)crc_file.delete()) : BoxedUnit.UNIT;
            }
            {
                this.directory$1 = file;
            }
        });
        LevelDBClient$.MODULE$.find_sequence_files(directory$1, ".index").foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Object, File> file) {
                FileSupport$.MODULE$.toRichFile((File)file._2()).recursiveDelete();
            }
        });
    }

    private ReplicationSupport$() {
        MODULE$ = this;
        this.WAL_ACTION = Buffer.ascii("wal");
        this.LOGIN_ACTION = Buffer.ascii("LevelDB Store Replication v1:login");
        this.SYNC_ACTION = Buffer.ascii("sync");
        this.GET_ACTION = Buffer.ascii("get");
        this.ACK_ACTION = Buffer.ascii("ack");
        this.OK_ACTION = Buffer.ascii("ok");
        this.DISCONNECT_ACTION = Buffer.ascii("disconnect");
        this.ERROR_ACTION = Buffer.ascii("error");
        this.LOG_DELETE_ACTION = Buffer.ascii("rm");
    }
}

