/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.Stomp;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.DataByteArrayInputStream;

public class StompCodec {
    static final byte[] crlfcrlf = new byte[]{13, 10, 13, 10};
    TcpTransport transport;
    ByteArrayOutputStream currentCommand = new ByteArrayOutputStream();
    boolean processedHeaders = false;
    String action;
    HashMap<String, String> headers;
    int contentLength = -1;
    int readLength = 0;
    int previousByte = -1;
    boolean awaitingCommandStart = true;
    String version = "1.0";

    public StompCodec(TcpTransport transport) {
        this.transport = transport;
    }

    public void parse(ByteArrayInputStream input, int readSize) throws Exception {
        int i = 0;
        while (i++ < readSize) {
            int b = input.read();
            if (!this.processedHeaders && this.previousByte == 0 && b == 0) continue;
            if (!this.processedHeaders) {
                if (this.awaitingCommandStart && b == 10) continue;
                this.awaitingCommandStart = false;
                this.currentCommand.write(b);
                if (b == 10 && (this.previousByte == 10 || this.currentCommand.endsWith(crlfcrlf))) {
                    StompWireFormat wf = (StompWireFormat)this.transport.getWireFormat();
                    DataByteArrayInputStream data = new DataByteArrayInputStream(this.currentCommand.toByteArray());
                    this.action = wf.parseAction((DataInput)data);
                    this.headers = wf.parseHeaders((DataInput)data);
                    try {
                        String contentLengthHeader = this.headers.get("content-length");
                        this.contentLength = (this.action.equals("SEND") || this.action.equals("MESSAGE")) && contentLengthHeader != null ? wf.parseContentLength(contentLengthHeader) : -1;
                    }
                    catch (ProtocolException ignore) {
                        // empty catch block
                    }
                    this.processedHeaders = true;
                    this.currentCommand.reset();
                }
            } else if (this.contentLength == -1) {
                if (b == 0) {
                    this.processCommand();
                } else {
                    this.currentCommand.write(b);
                }
            } else if (this.readLength++ == this.contentLength) {
                this.processCommand();
                this.readLength = 0;
            } else {
                this.currentCommand.write(b);
            }
            this.previousByte = b;
        }
    }

    protected void processCommand() throws Exception {
        StompFrame frame = new StompFrame(this.action, this.headers, this.currentCommand.toByteArray());
        this.transport.doConsume((Object)frame);
        this.processedHeaders = false;
        this.awaitingCommandStart = true;
        this.currentCommand.reset();
        this.contentLength = -1;
    }

    public static String detectVersion(Map<String, String> headers) throws ProtocolException {
        String accepts = headers.get("accept-version");
        if (accepts == null) {
            accepts = "1.0";
        }
        HashSet<String> acceptsVersions = new HashSet<String>(Arrays.asList(accepts.trim().split(",")));
        acceptsVersions.retainAll(Arrays.asList(Stomp.SUPPORTED_PROTOCOL_VERSIONS));
        if (acceptsVersions.isEmpty()) {
            throw new ProtocolException("Invalid Protocol version[" + accepts + "], supported versions are: " + Arrays.toString(Stomp.SUPPORTED_PROTOCOL_VERSIONS), true);
        }
        return Collections.max(acceptsVersions);
    }
}

