/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

/**
 * @version $Revision: 1.1 $
 */
public class DelayerTest extends ContextTestSupport {

    public void testSendingMessageGetsDelayed() throws Exception {
        MockEndpoint resultEndpoint = resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(0);

        template.sendBodyAndHeader("seda:a", "<hello>world!</hello>", "JMSTimestamp", System
            .currentTimeMillis());
        resultEndpoint.assertIsSatisfied();

        // now if we wait a bit longer we should receive the message!
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.assertIsSatisfied();

        template.sendBody("seda:b", "<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();

        // now if we wait a bit longer we should receive the message!
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();

    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder() {
            public void configure() {
                // START SNIPPET: ex
                from("seda:a").delayer(header("JMSTimestamp"), 3000).to("mock:result");
                // END SNIPPET: ex
                // START SNIPPET: ex2
                from("seda:b").delayer(3000).to("mock:result");
                // END SNIPPET: ex2
            }
        };
    }
}
