/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.channel.RendezvousChannel;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.selector.MessageSelector;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueChannel
extends AbstractMessageChannel {
    public static final int DEFAULT_CAPACITY = 100;
    private final BlockingQueue<Message<?>> queue;

    public QueueChannel(BlockingQueue<Message<?>> queue, DispatcherPolicy dispatcherPolicy) {
        super(dispatcherPolicy != null ? dispatcherPolicy : new DispatcherPolicy());
        Assert.notNull(queue, (String)"'queue' must not be null");
        this.queue = queue;
    }

    public QueueChannel(int capacity, DispatcherPolicy dispatcherPolicy) {
        super(dispatcherPolicy != null ? dispatcherPolicy : new DispatcherPolicy());
        Assert.isTrue((capacity > 0 ? 1 : 0) != 0, (String)("The capacity must be a positive integer. For a zero-capacity alternative, consider '" + RendezvousChannel.class + "'"));
        this.queue = new LinkedBlockingQueue(capacity);
    }

    public QueueChannel(int capacity) {
        this(capacity, null);
    }

    public QueueChannel() {
        this(100, null);
    }

    @Override
    protected boolean doSend(Message<?> message, long timeout) {
        Assert.notNull(message, (String)"'message' must not be null");
        try {
            if (timeout > 0L) {
                return this.queue.offer(message, timeout, TimeUnit.MILLISECONDS);
            }
            if (timeout == 0L) {
                return this.queue.offer(message);
            }
            this.queue.put(message);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    protected Message<?> doReceive(long timeout) {
        try {
            if (timeout > 0L) {
                return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            }
            if (timeout == 0L) {
                return (Message)this.queue.poll();
            }
            return this.queue.take();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public List<Message<?>> clear() {
        ArrayList clearedMessages = new ArrayList();
        this.queue.drainTo(clearedMessages);
        return clearedMessages;
    }

    @Override
    public List<Message<?>> purge(MessageSelector selector) {
        Object[] array;
        if (selector == null) {
            return this.clear();
        }
        ArrayList purgedMessages = new ArrayList();
        Object[] objectArray = array = this.queue.toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Message message = (Message)o;
            if (!selector.accept(message) && this.queue.remove(message)) {
                purgedMessages.add(message);
            }
            ++n2;
        }
        return purgedMessages;
    }
}

