/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.channel.interceptor.MessageSelectingInterceptor;
import org.springframework.integration.message.selector.PayloadTypeSelector;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChannelParser
extends AbstractSingleBeanDefinitionParser {
    private static final String PUBLISH_SUBSCRIBE_ATTRIBUTE = "publish-subscribe";
    private static final String DISPATCHER_POLICY_ELEMENT = "dispatcher-policy";
    private static final String DATATYPE_ATTRIBUTE = "datatype";
    private static final String INTERCEPTOR_ELEMENT = "interceptor";
    private static final String INTERCEPTORS_PROPERTY = "interceptors";

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected abstract Class<?> getBeanClass(Element var1);

    protected abstract void configureConstructorArgs(BeanDefinitionBuilder var1, Element var2, DispatcherPolicy var3);

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        boolean isPublishSubscribe = "true".equals(element.getAttribute(PUBLISH_SUBSCRIBE_ATTRIBUTE));
        DispatcherPolicy dispatcherPolicy = new DispatcherPolicy(isPublishSubscribe);
        ManagedList interceptors = new ManagedList();
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1) {
                String localName = child.getLocalName();
                if (DISPATCHER_POLICY_ELEMENT.equals(localName)) {
                    this.configureDispatcherPolicy((Element)child, dispatcherPolicy);
                } else if (INTERCEPTOR_ELEMENT.equals(localName)) {
                    String ref = ((Element)child).getAttribute("ref");
                    interceptors.add((Object)new RuntimeBeanReference(ref));
                }
            }
            ++i;
        }
        String datatypeAttr = element.getAttribute(DATATYPE_ATTRIBUTE);
        if (StringUtils.hasText((String)datatypeAttr)) {
            String[] datatypes = StringUtils.commaDelimitedListToStringArray((String)datatypeAttr);
            RootBeanDefinition selectorDef = new RootBeanDefinition(PayloadTypeSelector.class);
            selectorDef.getConstructorArgumentValues().addGenericArgumentValue((Object)datatypes);
            String selectorBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)selectorDef);
            BeanComponentDefinition selectorComponent = new BeanComponentDefinition((BeanDefinition)selectorDef, selectorBeanName);
            parserContext.registerBeanComponent(selectorComponent);
            RootBeanDefinition interceptorDef = new RootBeanDefinition(MessageSelectingInterceptor.class);
            interceptorDef.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(selectorBeanName));
            String interceptorBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)interceptorDef);
            BeanComponentDefinition interceptorComponent = new BeanComponentDefinition((BeanDefinition)interceptorDef, interceptorBeanName);
            parserContext.registerBeanComponent(interceptorComponent);
            interceptors.add((Object)new RuntimeBeanReference(interceptorBeanName));
        }
        builder.addPropertyValue(INTERCEPTORS_PROPERTY, (Object)interceptors);
        this.configureConstructorArgs(builder, element, dispatcherPolicy);
    }

    private void configureDispatcherPolicy(Element element, DispatcherPolicy dispatcherPolicy) {
        String shouldFailOnRejectionLimit;
        String retryInterval;
        String rejectionLimit;
        String receiveTimeout;
        String maxMessagesPerTask = element.getAttribute("max-messages-per-task");
        if (StringUtils.hasText((String)maxMessagesPerTask)) {
            dispatcherPolicy.setMaxMessagesPerTask(Integer.parseInt(maxMessagesPerTask));
        }
        if (StringUtils.hasText((String)(receiveTimeout = element.getAttribute("receive-timeout")))) {
            dispatcherPolicy.setReceiveTimeout(Long.parseLong(receiveTimeout));
        }
        if (StringUtils.hasText((String)(rejectionLimit = element.getAttribute("rejection-limit")))) {
            dispatcherPolicy.setRejectionLimit(Integer.parseInt(rejectionLimit));
        }
        if (StringUtils.hasText((String)(retryInterval = element.getAttribute("retry-interval")))) {
            dispatcherPolicy.setRetryInterval(Long.parseLong(retryInterval));
        }
        if (StringUtils.hasText((String)(shouldFailOnRejectionLimit = element.getAttribute("should-fail-on-rejection-limit")))) {
            dispatcherPolicy.setShouldFailOnRejectionLimit("true".equals(shouldFailOnRejectionLimit));
        }
    }
}

