/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel.factory;

import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.channel.factory.AbstractChannelFactory;
import org.springframework.util.Assert;

public class QueueChannelFactory
extends AbstractChannelFactory {
    int queueCapacity = 100;

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public void setQueueCapacity(int queueCapacity) {
        Assert.state((queueCapacity > 0 ? 1 : 0) != 0, (String)"Queue capacity must be greater than zero");
        this.queueCapacity = queueCapacity;
    }

    protected AbstractMessageChannel createChannelInternal(DispatcherPolicy dispatcherPolicy) {
        return new QueueChannel(this.queueCapacity, dispatcherPolicy);
    }
}

