/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.handler.DefaultMessageHandlerAdapter;
import org.springframework.integration.handler.MessageHandlerChain;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HandlerParser
implements BeanDefinitionParser {
    private static final String HANDLER_CHAIN_ELEMENT = "handler-chain";
    private static final String HANDLER_ELEMENT = "handler";
    private static final String HANDLERS_PROPERTY = "handlers";
    private static final String OBJECT_PROPERTY = "object";
    private static final String METHOD_NAME_PROPERTY = "methodName";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        if (HANDLER_CHAIN_ELEMENT.equals(element.getLocalName())) {
            return this.parseHandlerChain(element, parserContext);
        }
        if (HANDLER_ELEMENT.equals(element.getLocalName())) {
            return this.parseHandler(element, parserContext, null);
        }
        return null;
    }

    private BeanDefinition parseHandlerChain(Element element, ParserContext parserContext) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(MessageHandlerChain.class);
        ManagedList handlers = new ManagedList();
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            String localName;
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1 && HANDLER_ELEMENT.equals(localName = child.getLocalName())) {
                this.parseHandler((Element)child, parserContext, handlers);
            }
            ++i;
        }
        beanDefinition.getPropertyValues().addPropertyValue(HANDLERS_PROPERTY, (Object)handlers);
        String id = element.getAttribute("id");
        String beanName = StringUtils.hasText((String)id) ? id : parserContext.getReaderContext().generateBeanName((BeanDefinition)beanDefinition);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDefinition, beanName));
        return beanDefinition;
    }

    private BeanDefinition parseHandler(Element element, ParserContext parserContext, ManagedList handlers) {
        boolean isInnerHandler = handlers != null;
        String ref = element.getAttribute("ref");
        String method = element.getAttribute("method");
        String id = element.getAttribute("id");
        if (!(isInnerHandler || StringUtils.hasText((String)id) && StringUtils.hasText((String)ref) && StringUtils.hasText((String)method))) {
            parserContext.getReaderContext().error("Top-level <handler> elements must provide 'id', 'ref', and 'method' attributes.", parserContext.extractSource((Object)element));
        }
        if (isInnerHandler && StringUtils.hasText((String)id)) {
            parserContext.getReaderContext().error("The 'id' attribute is only supported for top-level <handler> elements.", parserContext.extractSource((Object)element));
        }
        if (StringUtils.hasText((String)method)) {
            BeanDefinitionHolder bdh = this.parseHandlerAdapter(id, ref, method, parserContext, isInnerHandler);
            if (handlers != null) {
                handlers.add((Object)bdh.getBeanDefinition());
                return null;
            }
            return bdh.getBeanDefinition();
        }
        if (StringUtils.hasText((String)id)) {
            parserContext.getReaderContext().error("The 'id' attribute is only supported for handler adapters (when 'method' is also provided).", parserContext.extractSource((Object)element));
        }
        if (handlers != null) {
            handlers.add((Object)new RuntimeBeanReference(ref));
        }
        return null;
    }

    private BeanDefinitionHolder parseHandlerAdapter(String id, String handlerRef, String handlerMethod, ParserContext parserContext, boolean isInnerHandler) {
        String adapterBeanName;
        RootBeanDefinition handlerAdapterDef = new RootBeanDefinition(DefaultMessageHandlerAdapter.class);
        handlerAdapterDef.getPropertyValues().addPropertyValue(OBJECT_PROPERTY, (Object)new RuntimeBeanReference(handlerRef));
        handlerAdapterDef.getPropertyValues().addPropertyValue(METHOD_NAME_PROPERTY, (Object)handlerMethod);
        String string = adapterBeanName = StringUtils.hasText((String)id) ? id : BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)handlerAdapterDef, (BeanDefinitionRegistry)parserContext.getRegistry(), (boolean)isInnerHandler);
        if (!isInnerHandler) {
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)handlerAdapterDef, adapterBeanName));
        }
        return new BeanDefinitionHolder((BeanDefinition)handlerAdapterDef, adapterBeanName);
    }
}

