/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.bus.MessageBus;
import org.springframework.integration.bus.MessageBusAwareBeanPostProcessor;
import org.springframework.integration.config.IntegrationNamespaceUtils;
import org.springframework.integration.endpoint.ConcurrencyPolicy;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBusParser
extends AbstractSimpleBeanDefinitionParser {
    public static final String MESSAGE_BUS_BEAN_NAME = "internal.MessageBus";
    public static final String MESSAGE_BUS_AWARE_POST_PROCESSOR_BEAN_NAME = "internal.MessageBusAwareBeanPostProcessor";
    private static final Class<?> MESSAGE_BUS_CLASS = MessageBus.class;
    private static final String ERROR_CHANNEL_ATTRIBUTE = "error-channel";
    private static final String DEFAULT_CONCURRENCY_ELEMENT = "default-concurrency";
    private static final String DEFAULT_CONCURRENCY_PROPERTY = "defaultConcurrencyPolicy";

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        if (parserContext.getRegistry().containsBeanDefinition(MESSAGE_BUS_BEAN_NAME)) {
            throw new ConfigurationException("Only one instance of '" + MESSAGE_BUS_CLASS.getSimpleName() + "' is allowed per ApplicationContext.");
        }
        return MESSAGE_BUS_BEAN_NAME;
    }

    protected Class<?> getBeanClass(Element element) {
        return MESSAGE_BUS_CLASS;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !ERROR_CHANNEL_ATTRIBUTE.equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    protected void postProcess(BeanDefinitionBuilder beanDefinition, Element element) {
        String errorChannelRef = element.getAttribute(ERROR_CHANNEL_ATTRIBUTE);
        if (StringUtils.hasText((String)errorChannelRef)) {
            beanDefinition.addPropertyReference(Conventions.attributeNameToPropertyName((String)ERROR_CHANNEL_ATTRIBUTE), errorChannelRef);
        }
        this.registerDefaultConcurrencyIfAvailable(beanDefinition, element);
    }

    private void registerDefaultConcurrencyIfAvailable(BeanDefinitionBuilder beanDefinition, Element element) {
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            String localName;
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1 && DEFAULT_CONCURRENCY_ELEMENT.equals(localName = child.getLocalName())) {
                ConcurrencyPolicy policy = IntegrationNamespaceUtils.parseConcurrencyPolicy((Element)child);
                beanDefinition.addPropertyValue(DEFAULT_CONCURRENCY_PROPERTY, (Object)policy);
            }
            ++i;
        }
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        this.addPostProcessors(parserContext);
    }

    private void addPostProcessors(ParserContext parserContext) {
        RootBeanDefinition postProcessorDefinition = new RootBeanDefinition(MessageBusAwareBeanPostProcessor.class);
        postProcessorDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(MESSAGE_BUS_BEAN_NAME));
        parserContext.getRegistry().registerBeanDefinition(MESSAGE_BUS_AWARE_POST_PROCESSOR_BEAN_NAME, (BeanDefinition)postProcessorDefinition);
    }
}

