/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scheduling;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.message.ErrorMessage;
import org.springframework.integration.util.ErrorHandler;

public class MessagePublishingErrorHandler
implements ErrorHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile MessageChannel errorChannel;
    private final long sendTimeout = 1000L;

    public MessagePublishingErrorHandler() {
    }

    public MessagePublishingErrorHandler(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public final void handle(Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"failure occurred in messaging task", t);
        }
        if (this.errorChannel != null) {
            try {
                this.errorChannel.send(new ErrorMessage(t), 1000L);
            }
            catch (Throwable throwable) {}
        }
    }
}

