/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.integration.channel.ChannelInterceptor;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageChannel
implements MessageChannel,
BeanNameAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile String name;
    private final ChannelInterceptorList interceptors = new ChannelInterceptorList();
    private final DispatcherPolicy dispatcherPolicy;

    public AbstractMessageChannel(DispatcherPolicy dispatcherPolicy) {
        this.dispatcherPolicy = dispatcherPolicy;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setBeanName(String beanName) {
        this.setName(beanName);
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        this.interceptors.set(interceptors);
    }

    public void addInterceptor(ChannelInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public DispatcherPolicy getDispatcherPolicy() {
        return this.dispatcherPolicy;
    }

    @Override
    public final boolean send(Message<?> message) {
        return this.send(message, -1L);
    }

    @Override
    public final boolean send(Message<?> message, long timeout) {
        if (!this.interceptors.preSend(message, this)) {
            return false;
        }
        boolean sent = this.doSend(message, timeout);
        this.interceptors.postSend(message, this, sent);
        return sent;
    }

    @Override
    public final Message<?> receive() {
        return this.receive(-1L);
    }

    public final Message<?> receive(long timeout) {
        if (!this.interceptors.preReceive(this)) {
            return null;
        }
        Message<?> message = this.doReceive(timeout);
        this.interceptors.postReceive(message, this);
        return message;
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }

    protected abstract boolean doSend(Message<?> var1, long var2);

    protected abstract Message<?> doReceive(long var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChannelInterceptorList {
        private final List<ChannelInterceptor> interceptors = new CopyOnWriteArrayList<ChannelInterceptor>();

        private ChannelInterceptorList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean set(List<ChannelInterceptor> interceptors) {
            List<ChannelInterceptor> list = this.interceptors;
            synchronized (list) {
                this.interceptors.clear();
                return this.interceptors.addAll(interceptors);
            }
        }

        public boolean add(ChannelInterceptor interceptor) {
            return this.interceptors.add(interceptor);
        }

        public boolean preSend(Message<?> message, MessageChannel channel) {
            if (AbstractMessageChannel.this.logger.isDebugEnabled()) {
                AbstractMessageChannel.this.logger.debug((Object)("preSend on channel '" + channel + "', message: " + message));
            }
            for (ChannelInterceptor interceptor : this.interceptors) {
                if (interceptor.preSend(message, channel)) continue;
                return false;
            }
            return true;
        }

        public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
            if (AbstractMessageChannel.this.logger.isDebugEnabled()) {
                AbstractMessageChannel.this.logger.debug((Object)("postSend (sent=" + sent + ") on channel '" + channel + "', message: " + message));
            }
            for (ChannelInterceptor interceptor : this.interceptors) {
                interceptor.postSend(message, channel, sent);
            }
        }

        public boolean preReceive(MessageChannel channel) {
            if (AbstractMessageChannel.this.logger.isDebugEnabled()) {
                AbstractMessageChannel.this.logger.debug((Object)("preReceive on channel '" + channel + "'"));
            }
            for (ChannelInterceptor interceptor : this.interceptors) {
                if (interceptor.preReceive(channel)) continue;
                return false;
            }
            return true;
        }

        public void postReceive(Message<?> message, MessageChannel channel) {
            if (AbstractMessageChannel.this.logger.isDebugEnabled()) {
                AbstractMessageChannel.this.logger.debug((Object)("postReceive on channel '" + channel + "', message: " + message));
            }
            for (ChannelInterceptor interceptor : this.interceptors) {
                interceptor.postReceive(message, channel);
            }
        }
    }
}

