/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.integration.endpoint.ConcurrencyPolicy;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class IntegrationNamespaceUtils {
    private static final String CORE_SIZE_ATTRIBUTE = "core";
    private static final String MAX_SIZE_ATTRIBUTE = "max";
    private static final String QUEUE_CAPACITY_ATTRIBUTE = "queue-capacity";
    private static final String KEEP_ALIVE_ATTRIBUTE = "keep-alive";

    public static ConcurrencyPolicy parseConcurrencyPolicy(Element element) {
        ConcurrencyPolicy policy = new ConcurrencyPolicy();
        String coreSize = element.getAttribute(CORE_SIZE_ATTRIBUTE);
        String maxSize = element.getAttribute(MAX_SIZE_ATTRIBUTE);
        String queueCapacity = element.getAttribute(QUEUE_CAPACITY_ATTRIBUTE);
        String keepAlive = element.getAttribute(KEEP_ALIVE_ATTRIBUTE);
        if (StringUtils.hasText((String)coreSize)) {
            policy.setCoreSize(Integer.parseInt(coreSize));
        }
        if (StringUtils.hasText((String)maxSize)) {
            policy.setMaxSize(Integer.parseInt(maxSize));
        }
        if (StringUtils.hasText((String)queueCapacity)) {
            policy.setQueueCapacity(Integer.parseInt(queueCapacity));
        }
        if (StringUtils.hasText((String)keepAlive)) {
            policy.setKeepAliveSeconds(Integer.parseInt(keepAlive));
        }
        return policy;
    }

    public static void setValueIfAttributeDefined(RootBeanDefinition beanDefinition, String propertyName, Element element, String attributeName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            beanDefinition.getPropertyValues().addPropertyValue(propertyName, (Object)attributeValue);
        }
    }

    public static void setBeanReferenceIfAttributeDefined(RootBeanDefinition beanDefinition, String propertyName, Element element, String attributeName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            beanDefinition.getPropertyValues().addPropertyValue(propertyName, (Object)new RuntimeBeanReference(attributeValue));
        }
    }
}

