/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.LinkedList;
import java.util.List;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.dispatcher.PollingDispatcher;
import org.springframework.integration.dispatcher.SimpleDispatcher;
import org.springframework.integration.message.BlockingSource;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageDeliveryAware;
import org.springframework.integration.message.MessageDeliveryException;
import org.springframework.integration.message.Source;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPollingDispatcher
extends SimpleDispatcher
implements PollingDispatcher {
    private final Source<?> source;

    public DefaultPollingDispatcher(MessageChannel channel) {
        this(channel, channel.getDispatcherPolicy());
    }

    public DefaultPollingDispatcher(Source<?> source, DispatcherPolicy dispatcherPolicy) {
        super(dispatcherPolicy);
        Assert.notNull(source, (String)"source must not be null");
        this.source = source;
        this.dispatcherPolicy.setReceiveTimeout(0L);
    }

    @Override
    public boolean dispatch(Message<?> message) {
        boolean sent = super.dispatch(message);
        if (this.source instanceof MessageDeliveryAware) {
            if (sent) {
                ((MessageDeliveryAware)((Object)this.source)).onSend(message);
            } else {
                ((MessageDeliveryAware)((Object)this.source)).onFailure(new MessageDeliveryException(message, "failed to send message"));
            }
        }
        return sent;
    }

    @Override
    public List<Message<?>> poll() {
        LinkedList messages = new LinkedList();
        int limit = this.dispatcherPolicy.getMaxMessagesPerTask();
        while (messages.size() < limit) {
            Message<Object> message = null;
            long timeout = this.dispatcherPolicy.getReceiveTimeout();
            message = this.source instanceof BlockingSource && timeout >= 0L ? ((BlockingSource)this.source).receive(timeout) : this.source.receive();
            if (message == null) {
                return messages;
            }
            messages.add(message);
        }
        return messages;
    }
}

