/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.lang.reflect.Method;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.dispatcher.DefaultPollingDispatcher;
import org.springframework.integration.dispatcher.PollingDispatcher;
import org.springframework.integration.dispatcher.PollingDispatcherTask;
import org.springframework.integration.endpoint.AbstractSourceEndpoint;
import org.springframework.integration.message.Source;
import org.springframework.integration.scheduling.MessagingTask;
import org.springframework.integration.scheduling.PollingSchedule;
import org.springframework.integration.scheduling.Schedule;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollingSourceEndpoint
extends AbstractSourceEndpoint
implements MessagingTask,
InitializingBean {
    private final Schedule schedule;
    private final DispatcherPolicy dispatcherPolicy = new DispatcherPolicy();
    private volatile PollingDispatcher dispatcher;
    private volatile List<Advice> dispatchAdviceChain;
    private volatile MessagingTask task;
    private volatile List<Advice> taskAdviceChain;
    private volatile boolean taskInitialized;
    private final Object taskMonitor = new Object();

    public PollingSourceEndpoint(Source<?> source, MessageChannel channel, PollingSchedule schedule) {
        super(source, channel);
        Assert.notNull((Object)schedule, (String)"schedule must not be null");
        this.dispatcher = new DefaultPollingDispatcher(source, this.dispatcherPolicy);
        this.dispatcher.subscribe(this.getChannel());
        this.schedule = schedule;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.dispatcherPolicy.setMaxMessagesPerTask(maxMessagesPerTask);
    }

    public void setSendTimeout(long sendTimeout) {
        this.dispatcher.setSendTimeout(sendTimeout);
    }

    public void setTaskAdviceChain(List<Advice> taskAdviceChain) {
        this.taskAdviceChain = taskAdviceChain;
    }

    public void setDispatchAdviceChain(List<Advice> dispatchAdviceChain) {
        this.dispatchAdviceChain = dispatchAdviceChain;
    }

    @Override
    public Schedule getSchedule() {
        return this.schedule;
    }

    public void afterPropertiesSet() {
        this.initializeTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTask() {
        Object object = this.taskMonitor;
        synchronized (object) {
            if (this.taskInitialized) {
                return;
            }
            this.refreshTask();
            this.taskInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTask() {
        Object object = this.taskMonitor;
        synchronized (object) {
            ProxyFactory proxyFactory;
            PollingDispatcher dispatcherProxy = null;
            if (this.dispatchAdviceChain != null && this.dispatchAdviceChain.size() > 0) {
                proxyFactory = new ProxyFactory((Object)this.dispatcher);
                proxyFactory.setInterfaces(new Class[]{PollingDispatcher.class});
                for (Advice advice : this.dispatchAdviceChain) {
                    proxyFactory.addAdvisor((Advisor)new MethodNameAdvisor(advice, "dispatch"));
                }
                dispatcherProxy = (PollingDispatcher)proxyFactory.getProxy();
            }
            this.task = new PollingDispatcherTask(dispatcherProxy != null ? dispatcherProxy : this.dispatcher, this.schedule);
            if (this.taskAdviceChain != null && this.taskAdviceChain.size() > 0) {
                proxyFactory = new ProxyFactory((Object)this.task);
                proxyFactory.setInterfaces(new Class[]{MessagingTask.class});
                for (Advice advice : this.taskAdviceChain) {
                    proxyFactory.addAdvisor((Advisor)new MethodNameAdvisor(advice, "run"));
                }
                this.task = (MessagingTask)proxyFactory.getProxy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessagingTask getTask() {
        Object object = this.taskMonitor;
        synchronized (object) {
            if (!this.taskInitialized) {
                this.initializeTask();
            }
            return this.task;
        }
    }

    @Override
    public void run() {
        this.getTask().run();
    }

    private static class MethodNameAdvisor
    extends StaticMethodMatcherPointcutAdvisor {
        private final String methodName;

        MethodNameAdvisor(Advice advice, String methodName) {
            super(advice);
            this.methodName = methodName;
        }

        public boolean matches(Method method, Class targetClass) {
            return method.getName().equals(this.methodName);
        }
    }
}

