/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.integration.message.RetrievalBlockingMessageStore;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseCorrelator
implements MessageHandler {
    private volatile long defaultTimeout = 5000L;
    private final RetrievalBlockingMessageStore messageStore;

    public ResponseCorrelator(int capacity) {
        this.messageStore = new RetrievalBlockingMessageStore(capacity);
    }

    public void setDefaultTimeout(long defaultTimeout) {
        Assert.isTrue((defaultTimeout >= 0L ? 1 : 0) != 0, (String)"'defaultTimeout' must not be negative");
        this.defaultTimeout = defaultTimeout;
    }

    @Override
    public Message<?> handle(Message<?> message) {
        Object correlationId = this.getCorrelationId(message);
        if (correlationId == null) {
            throw new MessageHandlingException(message, "unable to handle response, message has no correlationId: " + message);
        }
        this.messageStore.put(correlationId, message);
        return null;
    }

    public Message<?> getResponse(Object correlationId) {
        return this.getResponse(correlationId, this.defaultTimeout);
    }

    public Message<?> getResponse(Object correlationId, long timeout) {
        Assert.notNull((Object)correlationId, (String)"'correlationId' must not be null");
        return this.messageStore.remove(correlationId, timeout);
    }

    protected Object getCorrelationId(Message<?> message) {
        return message.getHeader().getCorrelationId();
    }
}

