/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.ArrayList;
import java.util.List;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.message.Message;
import org.springframework.integration.router.AbstractRoutingMessageHandler;
import org.springframework.integration.router.MultiChannelNameResolver;
import org.springframework.integration.router.MultiChannelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiChannelRouter
extends AbstractRoutingMessageHandler {
    private MultiChannelResolver channelResolver;
    private MultiChannelNameResolver channelNameResolver;

    public void setChannelResolver(MultiChannelResolver channelResolver) {
        this.channelResolver = channelResolver;
    }

    public void setChannelNameResolver(MultiChannelNameResolver channelNameResolver) {
        this.channelNameResolver = channelNameResolver;
    }

    @Override
    public void validate() {
        if (!(this.channelResolver != null ^ this.channelNameResolver != null)) {
            throw new ConfigurationException("exactly one of 'channelResolver' or 'channelNameResolver' must be provided");
        }
        if (this.channelNameResolver != null && this.getChannelRegistry() == null) {
            throw new ConfigurationException("'channelRegistry' is required when resolving by channel name");
        }
    }

    @Override
    public List<MessageChannel> resolveChannels(Message<?> message) {
        if (this.channelResolver != null) {
            return this.channelResolver.resolve(message);
        }
        if (this.channelNameResolver == null || this.getChannelRegistry() == null) {
            throw new ConfigurationException("router configuration requires either a 'channelResolver' or both 'channelNameResolver' and 'channelRegistry'");
        }
        String[] channelNames = this.channelNameResolver.resolve(message);
        if (channelNames == null) {
            return null;
        }
        ArrayList<MessageChannel> channels = new ArrayList<MessageChannel>(channelNames.length);
        String[] stringArray = channelNames;
        int n = channelNames.length;
        int n2 = 0;
        while (n2 < n) {
            String channelName = stringArray[n2];
            MessageChannel channel = this.getChannelRegistry().lookupChannel(channelName);
            if (channel != null) {
                channels.add(channel);
            }
            ++n2;
        }
        return channels;
    }
}

