/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.message.Message;
import org.springframework.integration.router.ChannelResolver;
import org.springframework.integration.router.SingleChannelRouter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadTypeRouter
extends SingleChannelRouter {
    private Map<Class<?>, MessageChannel> channelMappings = new ConcurrentHashMap();
    private MessageChannel defaultChannel;

    public PayloadTypeRouter() {
        this.setChannelResolver(new PayloadTypeChannelResolver());
    }

    public void setChannelMappings(Map<Class<?>, MessageChannel> channelMappings) {
        Assert.notNull(channelMappings, (String)"'channelMappings' must not be null");
        this.channelMappings = channelMappings;
    }

    public void setDefaultChannel(MessageChannel defaultChannel) {
        this.defaultChannel = defaultChannel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PayloadTypeChannelResolver
    implements ChannelResolver {
        private PayloadTypeChannelResolver() {
        }

        @Override
        public MessageChannel resolve(Message<?> message) {
            MessageChannel channel = (MessageChannel)PayloadTypeRouter.this.channelMappings.get(message.getPayload().getClass());
            return channel != null ? channel : PayloadTypeRouter.this.defaultChannel;
        }
    }
}

