/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.handler.HandlerMethodInvoker;
import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.message.GenericMessage;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageCreator;
import org.springframework.integration.message.MessageMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvokingHandler
implements MessageHandler,
InitializingBean {
    private volatile Object object;
    private volatile String methodName;
    private volatile MessageMapper messageMapper;
    private volatile MessageCreator messageCreator;
    protected HandlerMethodInvoker<?> invoker;

    public void setObject(Object object) {
        Assert.notNull((Object)object, (String)"'object' must not be null");
        this.object = object;
    }

    public void setMethodName(String methodName) {
        Assert.notNull((Object)methodName, (String)"'methodName' must not be null");
        this.methodName = methodName;
    }

    public void setMessageMapper(MessageMapper messageMapper) {
        this.messageMapper = messageMapper;
    }

    public void setMessageCreator(MessageCreator messageCreator) {
        this.messageCreator = messageCreator;
    }

    public void afterPropertiesSet() {
        this.invoker = new HandlerMethodInvoker<Object>(this.object, this.methodName);
    }

    @Override
    public Message<?> handle(Message<?> message) {
        Object args = this.messageMapper != null ? this.messageMapper.mapMessage(message) : message.getPayload();
        Object result = this.invoker.invokeMethod(args);
        if (result == null) {
            return null;
        }
        return this.messageCreator != null ? this.messageCreator.createMessage(result) : new GenericMessage<Object>(result);
    }
}

