/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.aop.MessagePublishingInterceptor;
import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAwareMessagePublishingInterceptor
extends MessagePublishingInterceptor {
    private Class<? extends Annotation> publisherAnnotationType;
    private String channelAttributeName;
    private ChannelRegistry channelRegistry;

    public AnnotationAwareMessagePublishingInterceptor(Class<? extends Annotation> publisherAnnotationType, String channelAttributeName, ChannelRegistry channelRegistry) {
        Assert.notNull(publisherAnnotationType, (String)"'publisherAnnotationType' must not be null");
        Assert.notNull((Object)channelAttributeName, (String)"'channelAttributeName' must not be null");
        Assert.notNull((Object)channelRegistry, (String)"'channelRegistry' must not be null");
        this.publisherAnnotationType = publisherAnnotationType;
        this.channelAttributeName = channelAttributeName;
        this.channelRegistry = channelRegistry;
    }

    @Override
    protected MessageChannel resolveChannel(MethodInvocation invocation) {
        MessageChannel channel;
        String channelName;
        Class targetClass = AopUtils.getTargetClass((Object)invocation.getThis());
        Method method = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), (Class)targetClass);
        Annotation annotation = AnnotationUtils.getAnnotation((Method)method, this.publisherAnnotationType);
        if (annotation != null && (channelName = (String)AnnotationUtils.getValue((Annotation)annotation, (String)this.channelAttributeName)) != null && (channel = this.channelRegistry.lookupChannel(channelName)) != null) {
            return channel;
        }
        return super.resolveChannel(invocation);
    }
}

