/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.bus;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.integration.bus.MessageBus;
import org.springframework.integration.bus.MessageBusAware;
import org.springframework.util.Assert;

public class MessageBusAwareBeanPostProcessor
implements BeanPostProcessor {
    private final MessageBus messageBus;

    public MessageBusAwareBeanPostProcessor(MessageBus messageBus) {
        Assert.notNull((Object)messageBus, (String)"'messageBus' must not be null");
        this.messageBus = messageBus;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MessageBusAware) {
            ((MessageBusAware)bean).setMessageBus(this.messageBus);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

