/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.ArrayList;
import java.util.List;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.selector.MessageSelector;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelPurger {
    private final MessageChannel[] channels;
    private final MessageSelector selector;

    public ChannelPurger(MessageChannel ... channels) {
        this((MessageSelector)null, channels);
    }

    public ChannelPurger(MessageSelector selector, MessageChannel ... channels) {
        Assert.notEmpty((Object[])channels, (String)"at least one channel is required");
        if (channels.length == 1) {
            Assert.notNull((Object)channels[0], (String)"channel must not be null");
        }
        this.selector = selector;
        this.channels = channels;
    }

    public final List<Message<?>> purge() {
        ArrayList purgedMessages = new ArrayList();
        MessageChannel[] messageChannelArray = this.channels;
        int n = this.channels.length;
        int n2 = 0;
        while (n2 < n) {
            List<Message<?>> results;
            MessageChannel channel = messageChannelArray[n2];
            List<Message<?>> list = results = this.selector == null ? channel.clear() : channel.purge(this.selector);
            if (results != null) {
                purgedMessages.addAll(results);
            }
            ++n2;
        }
        return purgedMessages;
    }
}

