/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel.factory;

import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.bus.MessageBus;
import org.springframework.integration.bus.MessageBusAware;
import org.springframework.integration.channel.ChannelInterceptor;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.channel.factory.ChannelFactory;
import org.springframework.integration.channel.factory.QueueChannelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannelFactoryBean
implements FactoryBean,
MessageBusAware,
InitializingBean {
    private volatile ChannelFactory channelFactory;
    private volatile List<ChannelInterceptor> interceptors;
    private volatile DispatcherPolicy dispatcherPolicy;

    @Override
    public void setMessageBus(MessageBus messageBus) {
        this.channelFactory = messageBus.getChannelFactory();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.channelFactory == null) {
            this.channelFactory = new QueueChannelFactory();
        }
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setDispatcherPolicy(DispatcherPolicy dispatcherPolicy) {
        this.dispatcherPolicy = dispatcherPolicy;
    }

    public Object getObject() throws Exception {
        return this.channelFactory.getChannel(this.dispatcherPolicy, this.interceptors);
    }

    public Class getObjectType() {
        return MessageChannel.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

