/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel.interceptor;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.channel.interceptor.ChannelInterceptorAdapter;
import org.springframework.integration.message.GenericMessage;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.selector.MessageSelector;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireTap
extends ChannelInterceptorAdapter
implements Lifecycle {
    public static final String ORIGINAL_MESSAGE_ID_KEY = "_wireTap.originalMessageId";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MessageChannel secondaryChannel;
    private final List<MessageSelector> selectors = new CopyOnWriteArrayList<MessageSelector>();
    private volatile boolean running = true;

    public WireTap(MessageChannel secondaryChannel) {
        Assert.notNull((Object)secondaryChannel, (String)"'secondaryChannel' must not be null");
        this.secondaryChannel = secondaryChannel;
    }

    public WireTap(MessageChannel secondaryChannel, List<MessageSelector> selectors) {
        this(secondaryChannel);
        if (selectors != null) {
            this.selectors.addAll(selectors);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    @Override
    public boolean preSend(Message<?> message, MessageChannel channel) {
        if (this.running && this.selectorsAccept(message)) {
            GenericMessage duplicate = new GenericMessage(message.getPayload(), message.getHeader());
            duplicate.getHeader().setAttribute(ORIGINAL_MESSAGE_ID_KEY, message.getId());
            if (!this.secondaryChannel.send(duplicate, 0L) && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Failed to send message to secondary channel '" + this.secondaryChannel.getName() + "'. Check its capacity and whether it has any subscribers."));
            }
        }
        return true;
    }

    private boolean selectorsAccept(Message<?> message) {
        for (MessageSelector selector : this.selectors) {
            if (selector.accept(message)) continue;
            return false;
        }
        return true;
    }
}

