/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.handler.MessageHandlerNotRunningException;
import org.springframework.integration.handler.MessageHandlerRejectedExecutionException;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageDeliveryException;
import org.springframework.integration.message.Target;
import org.springframework.integration.util.ErrorHandler;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentTarget
implements Target,
DisposableBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Target target;
    private final ExecutorService executor;
    private volatile ErrorHandler errorHandler;

    public ConcurrentTarget(Target target, ExecutorService executor) {
        Assert.notNull((Object)target, (String)"'target' must not be null");
        Assert.notNull((Object)executor, (String)"'executor' must not be null");
        this.target = target;
        this.executor = executor;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void destroy() {
        this.executor.shutdown();
    }

    @Override
    public boolean send(Message<?> message) {
        if (this.executor.isShutdown()) {
            throw new MessageHandlerNotRunningException(message);
        }
        try {
            this.executor.execute(new TargetTask(message));
            return true;
        }
        catch (RuntimeException e) {
            throw new MessageHandlerRejectedExecutionException(message, (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TargetTask
    implements Runnable {
        private Message<?> message;

        TargetTask(Message<?> message) {
            this.message = message;
        }

        @Override
        public void run() {
            block5: {
                try {
                    if (!ConcurrentTarget.this.target.send(this.message)) {
                        throw new MessageDeliveryException(this.message, "failed to send message to target");
                    }
                }
                catch (Throwable t) {
                    if (ConcurrentTarget.this.logger.isDebugEnabled()) {
                        ConcurrentTarget.this.logger.debug((Object)"error occurred in handler execution", t);
                    }
                    if (ConcurrentTarget.this.errorHandler != null) {
                        ConcurrentTarget.this.errorHandler.handle(t);
                    }
                    if (!ConcurrentTarget.this.logger.isWarnEnabled() || ConcurrentTarget.this.logger.isDebugEnabled()) break block5;
                    ConcurrentTarget.this.logger.warn((Object)"error occurred in handler execution", t);
                }
            }
        }
    }
}

