/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.integration.channel.ChannelRegistryAware;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.endpoint.TargetEndpoint;
import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.handler.ReplyHandler;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageDeliveryException;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.integration.message.MessageHeader;
import org.springframework.integration.message.Target;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HandlerEndpoint
extends TargetEndpoint {
    private volatile MessageHandler handler;
    private volatile ReplyHandler replyHandler = new EndpointReplyHandler();
    private volatile long replyTimeout = 1000L;
    private volatile String outputChannelName;
    private volatile boolean returnAddressOverrides = false;

    public HandlerEndpoint(MessageHandler handler) {
        Assert.notNull((Object)handler, (String)"handler must not be null");
        this.handler = handler;
    }

    public MessageHandler getHandler() {
        return this.handler;
    }

    public void setReplyHandler(ReplyHandler replyHandler) {
        Assert.notNull((Object)replyHandler, (String)"'replyHandler' must not be null");
        this.replyHandler = replyHandler;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public void setOutputChannelName(String outputChannelName) {
        this.outputChannelName = outputChannelName;
    }

    public String getOutputChannelName() {
        return this.outputChannelName;
    }

    public void setReturnAddressOverrides(boolean returnAddressOverrides) {
        this.returnAddressOverrides = returnAddressOverrides;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.handler, (String)"handler must not be null");
        if (this.handler instanceof ChannelRegistryAware) {
            ((ChannelRegistryAware)((Object)this.handler)).setChannelRegistry(this.getChannelRegistry());
        }
        super.setTarget(new HandlerInvokingTarget(this.handler, this.replyHandler));
        super.afterPropertiesSet();
    }

    private MessageChannel resolveReplyChannel(MessageHeader originalMessageHeader) {
        if (this.returnAddressOverrides) {
            MessageChannel channel = this.getReturnAddress(originalMessageHeader);
            if (channel == null) {
                channel = this.getOutputChannel();
            }
            return channel;
        }
        MessageChannel channel = this.getOutputChannel();
        if (channel == null) {
            channel = this.getReturnAddress(originalMessageHeader);
        }
        return channel;
    }

    private MessageChannel getReturnAddress(MessageHeader originalMessageHeader) {
        Object returnAddress = originalMessageHeader.getReturnAddress();
        if (returnAddress != null) {
            String channelName;
            if (returnAddress instanceof MessageChannel) {
                return (MessageChannel)returnAddress;
            }
            ChannelRegistry registry = this.getChannelRegistry();
            if (returnAddress instanceof String && registry != null && StringUtils.hasText((String)(channelName = (String)returnAddress))) {
                return registry.lookupChannel(channelName);
            }
        }
        return null;
    }

    private MessageChannel getOutputChannel() {
        ChannelRegistry registry = this.getChannelRegistry();
        if (this.outputChannelName != null && registry != null) {
            return registry.lookupChannel(this.outputChannelName);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EndpointReplyHandler
    implements ReplyHandler {
        private EndpointReplyHandler() {
        }

        @Override
        public void handle(Message<?> replyMessage, MessageHeader originalMessageHeader) {
            if (replyMessage == null) {
                return;
            }
            MessageChannel replyChannel = HandlerEndpoint.this.resolveReplyChannel(originalMessageHeader);
            if (replyChannel == null) {
                throw new MessageHandlingException(replyMessage, "Unable to determine reply channel for message. Provide an 'outputChannelName' on the message endpoint or a 'returnAddress' in the message header");
            }
            if (HandlerEndpoint.this.logger.isDebugEnabled()) {
                HandlerEndpoint.this.logger.debug((Object)("endpoint '" + HandlerEndpoint.this + "' replying to channel '" + replyChannel + "' with message: " + replyMessage));
            }
            if (!replyChannel.send(replyMessage, HandlerEndpoint.this.replyTimeout)) {
                throw new MessageDeliveryException(replyMessage, "unable to send reply message within alloted timeout of " + HandlerEndpoint.this.replyTimeout + " milliseconds");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerInvokingTarget
    implements Target {
        private final MessageHandler handler;
        private final ReplyHandler replyHandler;

        public HandlerInvokingTarget(MessageHandler handler, ReplyHandler replyHandler) {
            this.handler = handler;
            this.replyHandler = replyHandler;
        }

        @Override
        public boolean send(Message<?> message) {
            Message<?> replyMessage = this.handler.handle(message);
            if (replyMessage != null) {
                if (replyMessage.getHeader().getCorrelationId() == null) {
                    replyMessage.getHeader().setCorrelationId(message.getId());
                }
                this.replyHandler.handle(replyMessage, message.getHeader());
            }
            return true;
        }
    }
}

