/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.message;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.integration.message.MessagePriority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHeader
implements Serializable {
    private final Date timestamp = new Date();
    private volatile Date expiration;
    private volatile Object correlationId;
    private volatile transient Object returnAddress;
    private volatile int sequenceNumber = 1;
    private volatile int sequenceSize = 1;
    private volatile MessagePriority priority = MessagePriority.NORMAL;
    private final Properties properties = new Properties();
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public Object getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(Object correlationId) {
        this.correlationId = correlationId;
    }

    public Object getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(Object returnAddress) {
        this.returnAddress = returnAddress;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public int getSequenceSize() {
        return this.sequenceSize;
    }

    public void setSequenceSize(int sequenceSize) {
        this.sequenceSize = sequenceSize;
    }

    public MessagePriority getPriority() {
        return this.priority;
    }

    public void setPriority(MessagePriority priority) {
        this.priority = priority;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String setProperty(String key, String value) {
        return (String)this.properties.setProperty(key, value);
    }

    public String removeProperty(String key) {
        return (String)this.properties.remove(key);
    }

    public Set<String> getPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>();
        for (Object key : this.properties.keySet()) {
            propertyNames.add((String)key);
        }
        return propertyNames;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Object setAttribute(String key, Object value) {
        return this.attributes.put(key, value);
    }

    public Object setAttributeIfAbsent(String key, Object value) {
        return this.attributes.putIfAbsent(key, value);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public String toString() {
        return "[CorrelationID=" + this.correlationId + "][Properties=" + this.properties + "][Attributes=" + this.attributes + "][Timestamp=" + this.timestamp + "][Expiration=" + this.expiration + "][Priority=" + (Object)((Object)this.priority) + "][Sequence #" + this.sequenceNumber + " (of " + this.sequenceSize + ")]";
    }
}

