/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.integration.channel.ChannelRegistryAware;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.handler.AbstractMessageHandlerAdapter;
import org.springframework.integration.handler.HandlerMethodInvoker;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterMessageHandlerAdapter
extends AbstractMessageHandlerAdapter
implements ChannelRegistryAware {
    private static final String PROPERTY_KEY = "property";
    private static final String ATTRIBUTE_KEY = "attribute";
    private final Method method;
    private final Map<String, ?> attributes;
    private volatile ChannelRegistry channelRegistry;

    public RouterMessageHandlerAdapter(Object object, Method method, Map<String, ?> attributes) {
        Assert.notNull((Object)object, (String)"'object' must not be null");
        Assert.notNull((Object)method, (String)"'method' must not be null");
        Assert.notNull(attributes, (String)"'attributes' must not be null");
        this.setObject(object);
        this.setMethodName(method.getName());
        this.method = method;
        this.attributes = attributes;
    }

    @Override
    public void setChannelRegistry(ChannelRegistry channelRegistry) {
        this.channelRegistry = channelRegistry;
    }

    @Override
    protected void initialize() {
        Object target = this.getObject();
        if (target != null && this.channelRegistry != null && target instanceof ChannelRegistryAware) {
            ((ChannelRegistryAware)target).setChannelRegistry(this.channelRegistry);
        }
    }

    protected Object doHandle(Message message, HandlerMethodInvoker invoker) {
        if (this.method.getParameterTypes().length != 1) {
            throw new ConfigurationException("method must accept exactly one parameter");
        }
        String propertyName = (String)this.attributes.get(PROPERTY_KEY);
        String attributeName = (String)this.attributes.get(ATTRIBUTE_KEY);
        Object retval = null;
        if (StringUtils.hasText((String)propertyName)) {
            if (StringUtils.hasText((String)attributeName)) {
                throw new ConfigurationException("cannot accept both 'property' and 'attribute'");
            }
            String property = message.getHeader().getProperty(propertyName);
            if (!StringUtils.hasText((String)property)) {
                throw new MessageHandlingException(message, "no '" + propertyName + "' property available for router method");
            }
            retval = this.invokeMethod(invoker, property);
        } else if (StringUtils.hasText((String)attributeName)) {
            Object attribute = message.getHeader().getAttribute(attributeName);
            if (attribute == null) {
                throw new MessageHandlingException(message, "no '" + attributeName + "' attribute available for router method");
            }
            retval = this.invokeMethod(invoker, attribute);
        } else {
            Class<?> type = this.method.getParameterTypes()[0];
            retval = type.equals(Message.class) ? this.invokeMethod(invoker, message) : this.invokeMethod(invoker, message.getPayload());
        }
        if (retval != null) {
            if (retval instanceof Collection) {
                Collection channels = (Collection)retval;
                for (Object channel : channels) {
                    if (channel instanceof MessageChannel) {
                        this.sendMessage(message, (MessageChannel)channel);
                        continue;
                    }
                    if (channel instanceof String) {
                        this.sendMessage(message, (String)channel);
                        continue;
                    }
                    throw new ConfigurationException("router method must return type 'MessageChannel' or 'String'");
                }
            } else if (retval instanceof MessageChannel[]) {
                MessageChannel[] messageChannelArray = (MessageChannel[])retval;
                int n = messageChannelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MessageChannel channel = messageChannelArray[n2];
                    this.sendMessage(message, channel);
                    ++n2;
                }
            } else if (retval instanceof String[]) {
                String[] stringArray = (String[])retval;
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String channelName = stringArray[n3];
                    this.sendMessage(message, channelName);
                    ++n3;
                }
            } else if (retval instanceof MessageChannel) {
                this.sendMessage(message, (MessageChannel)retval);
            } else if (retval instanceof String) {
                this.sendMessage(message, (String)retval);
            } else {
                throw new ConfigurationException("router method must return type 'MessageChannel' or 'String'");
            }
        }
        return null;
    }

    private Object invokeMethod(HandlerMethodInvoker<?> invoker, Object parameter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("invoking method '" + this.method.getName() + "' with parameter of type '" + parameter.getClass().getName() + "'"));
        }
        return invoker.invokeMethod(parameter);
    }

    private boolean sendMessage(Message<?> message, String channelName) {
        MessageChannel channel = this.channelRegistry.lookupChannel(channelName);
        if (channel == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("unable to resolve channel for name '" + channelName + "'"));
            }
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sending message to channel '" + channelName + "'"));
        }
        return this.sendMessage(message, channel);
    }

    private boolean sendMessage(Message<?> message, MessageChannel channel) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sending message to channel '" + channel + "'"));
        }
        return channel.send(message);
    }
}

