/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router.config;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.handler.config.AbstractMessageHandlerCreator;
import org.springframework.integration.router.AggregatingMessageHandler;
import org.springframework.integration.router.AggregatorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatorMessageHandlerCreator
extends AbstractMessageHandlerCreator {
    private static final String DEFAULT_REPLY_CHANNEL = "defaultReplyChannel";
    private static final String DISCARD_CHANNEL = "discardChannel";
    private static final String SEND_TIMEOUT = "sendTimeout";
    private static final String SEND_PARTIAL_RESULTS_ON_TIMEOUT = "sendPartialResultsOnTimeout";
    private static final String REAPER_INTERVAL = "reaperInterval";
    private static final String TIMEOUT = "timeout";
    private static final String TRACKED_CORRELATION_ID_CAPACITY = "trackedCorrelationIdCapacity";
    private final ChannelRegistry channelRegistry;

    public AggregatorMessageHandlerCreator(ChannelRegistry channelRegistry) {
        this.channelRegistry = channelRegistry;
    }

    @Override
    public MessageHandler doCreateHandler(Object object, Method method, Map<String, ?> attributes) {
        AggregatingMessageHandler messageHandler = new AggregatingMessageHandler(new AggregatorAdapter(object, method));
        if (attributes.containsKey(DEFAULT_REPLY_CHANNEL)) {
            messageHandler.setDefaultReplyChannel(this.channelRegistry.lookupChannel((String)attributes.get(DEFAULT_REPLY_CHANNEL)));
        }
        if (attributes.containsKey(DISCARD_CHANNEL)) {
            messageHandler.setDiscardChannel(this.channelRegistry.lookupChannel((String)attributes.get(DISCARD_CHANNEL)));
        }
        if (attributes.containsKey(SEND_TIMEOUT)) {
            messageHandler.setSendTimeout((Long)attributes.get(SEND_TIMEOUT));
        }
        if (attributes.containsKey(SEND_PARTIAL_RESULTS_ON_TIMEOUT)) {
            messageHandler.setSendPartialResultOnTimeout((Boolean)attributes.get(SEND_PARTIAL_RESULTS_ON_TIMEOUT));
        }
        if (attributes.containsKey(REAPER_INTERVAL)) {
            messageHandler.setReaperInterval((Long)attributes.get(REAPER_INTERVAL));
        }
        if (attributes.containsKey(TIMEOUT)) {
            messageHandler.setTimeout((Long)attributes.get(TIMEOUT));
        }
        if (attributes.containsKey(TRACKED_CORRELATION_ID_CAPACITY)) {
            messageHandler.setTrackedCorrelationIdCapacity((Integer)attributes.get(TRACKED_CORRELATION_ID_CAPACITY));
        }
        return messageHandler;
    }
}

