/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter;

import java.lang.reflect.Method;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.handler.HandlerMethodInvoker;
import org.springframework.integration.message.GenericMessage;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.Source;
import org.springframework.integration.util.MethodValidator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvokingSource<T>
implements Source<Object>,
InitializingBean {
    private T object;
    private String method;
    private HandlerMethodInvoker<T> invoker;

    public void setObject(T object) {
        Assert.notNull(object, (String)"'object' must not be null");
        this.object = object;
    }

    public void setMethod(String method) {
        Assert.notNull((Object)method, (String)"'method' must not be null");
        this.method = method;
    }

    public void afterPropertiesSet() {
        this.invoker = new HandlerMethodInvoker<T>(this.object, this.method);
        this.invoker.setMethodValidator(new MessageReceivingMethodValidator());
    }

    @Override
    public Message<Object> receive() {
        if (this.invoker == null) {
            this.afterPropertiesSet();
        }
        return new GenericMessage<Object>(this.invoker.invokeMethod(new Object[0]));
    }

    private static class MessageReceivingMethodValidator
    implements MethodValidator {
        private MessageReceivingMethodValidator() {
        }

        public void validate(Method method) {
            if (method.getReturnType().equals(Void.TYPE)) {
                throw new ConfigurationException("MethodInvokingSource requires a non-void returning method.");
            }
        }
    }
}

