/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.message.GenericMessage;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageCreator;

public class MessagePublishingInterceptor
implements MethodInterceptor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile MessageCreator messageCreator;
    private volatile MessageChannel defaultChannel;

    public void setDefaultChannel(MessageChannel defaultChannel) {
        this.defaultChannel = defaultChannel;
    }

    public void setMessageCreator(MessageCreator messageCreator) {
        this.messageCreator = messageCreator;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object retval = invocation.proceed();
        if (retval != null) {
            MessageChannel channel = this.resolveChannel(invocation);
            if (channel == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("unable to resolve channel for intercepted method '" + invocation.getMethod().getName() + "'"));
                }
            } else {
                Message<Object> message = this.messageCreator != null ? this.messageCreator.createMessage(retval) : new GenericMessage<Object>(retval);
                channel.send(message);
            }
        }
        return retval;
    }

    protected MessageChannel resolveChannel(MethodInvocation invocation) {
        return this.defaultChannel;
    }
}

