/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import java.lang.annotation.Annotation;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.integration.annotation.Publisher;
import org.springframework.integration.aop.AnnotationAwareMessagePublishingInterceptor;
import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherAnnotationAdvisor
extends AbstractPointcutAdvisor {
    private AnnotationAwareMessagePublishingInterceptor advice;
    private AnnotationMatchingPointcut pointcut;

    public PublisherAnnotationAdvisor(ChannelRegistry channelRegistry) {
        this(Publisher.class, "channel", channelRegistry);
    }

    public PublisherAnnotationAdvisor(Class<? extends Annotation> publisherAnnotationType, String channelNameAttribute, ChannelRegistry channelRegistry) {
        Assert.notNull(publisherAnnotationType, (String)"'publisherAnnotationType' must not be null");
        Assert.notNull((Object)channelNameAttribute, (String)"'channelNameAttribute' must not be null");
        Assert.notNull((Object)channelRegistry, (String)"'channelRegistry' must not be null");
        this.pointcut = AnnotationMatchingPointcut.forMethodAnnotation(publisherAnnotationType);
        this.advice = new AnnotationAwareMessagePublishingInterceptor(publisherAnnotationType, channelNameAttribute, channelRegistry);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }
}

