/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.bus;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.Lifecycle;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.bus.DefaultErrorChannel;
import org.springframework.integration.bus.SubscriptionManager;
import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.integration.channel.ChannelRegistryAware;
import org.springframework.integration.channel.DefaultChannelRegistry;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.channel.factory.ChannelFactory;
import org.springframework.integration.channel.factory.QueueChannelFactory;
import org.springframework.integration.endpoint.ConcurrencyPolicy;
import org.springframework.integration.endpoint.DefaultEndpointRegistry;
import org.springframework.integration.endpoint.EndpointRegistry;
import org.springframework.integration.endpoint.HandlerEndpoint;
import org.springframework.integration.endpoint.MessageEndpoint;
import org.springframework.integration.endpoint.SourceEndpoint;
import org.springframework.integration.endpoint.TargetEndpoint;
import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.message.Target;
import org.springframework.integration.scheduling.MessagePublishingErrorHandler;
import org.springframework.integration.scheduling.MessagingTask;
import org.springframework.integration.scheduling.MessagingTaskScheduler;
import org.springframework.integration.scheduling.Schedule;
import org.springframework.integration.scheduling.SimpleMessagingTaskScheduler;
import org.springframework.integration.scheduling.Subscription;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBus
implements ChannelRegistry,
EndpointRegistry,
ApplicationContextAware,
ApplicationListener,
Lifecycle {
    public static final String ERROR_CHANNEL_NAME = "errorChannel";
    private static final int DEFAULT_DISPATCHER_POOL_SIZE = 10;
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile ChannelFactory channelFactory = new QueueChannelFactory();
    private final ChannelRegistry channelRegistry = new DefaultChannelRegistry();
    private final EndpointRegistry endpointRegistry = new DefaultEndpointRegistry();
    private final Map<MessageChannel, SubscriptionManager> subscriptionManagers = new ConcurrentHashMap<MessageChannel, SubscriptionManager>();
    private final List<Lifecycle> lifecycleEndpoints = new CopyOnWriteArrayList<Lifecycle>();
    private volatile MessagingTaskScheduler taskScheduler;
    private volatile ScheduledExecutorService executor;
    private volatile ConcurrencyPolicy defaultConcurrencyPolicy;
    private volatile boolean autoCreateChannels;
    private volatile boolean autoStartup = true;
    private volatile boolean initialized;
    private volatile boolean initializing;
    private volatile boolean starting;
    private volatile boolean running;
    private final Object lifecycleMonitor = new Object();

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.notNull((Object)applicationContext, (String)"'applicationContext' must not be null");
        if (applicationContext.getBeanNamesForType(this.getClass()).length > 1) {
            throw new ConfigurationException("Only one instance of '" + this.getClass().getSimpleName() + "' is allowed per ApplicationContext.");
        }
        this.registerChannels(applicationContext);
    }

    public void setScheduledExecutorService(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void setDefaultConcurrencyPolicy(ConcurrencyPolicy defaultConcurrencyPolicy) {
        this.defaultConcurrencyPolicy = defaultConcurrencyPolicy;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setAutoCreateChannels(boolean autoCreateChannels) {
        this.autoCreateChannels = autoCreateChannels;
    }

    private void registerChannels(ApplicationContext context) {
        Map channelBeans = context.getBeansOfType(MessageChannel.class);
        for (Map.Entry entry : channelBeans.entrySet()) {
            this.registerChannel((String)entry.getKey(), (MessageChannel)entry.getValue());
        }
    }

    private void registerEndpoints(ApplicationContext context) {
        Map endpointBeans = context.getBeansOfType(MessageEndpoint.class);
        for (Map.Entry entry : endpointBeans.entrySet()) {
            this.registerEndpoint((String)entry.getKey(), (MessageEndpoint)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.initialized || this.initializing) {
                return;
            }
            this.initializing = true;
            if (this.executor == null) {
                this.executor = new ScheduledThreadPoolExecutor(10);
            }
            this.taskScheduler = new SimpleMessagingTaskScheduler(this.executor);
            if (this.getErrorChannel() == null) {
                this.setErrorChannel(new DefaultErrorChannel());
            }
            this.taskScheduler.setErrorHandler(new MessagePublishingErrorHandler(this.getErrorChannel()));
            this.initialized = true;
            this.initializing = false;
        }
    }

    public MessageChannel getErrorChannel() {
        return this.lookupChannel(ERROR_CHANNEL_NAME);
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.registerChannel(ERROR_CHANNEL_NAME, errorChannel);
    }

    @Override
    public MessageChannel lookupChannel(String channelName) {
        return this.channelRegistry.lookupChannel(channelName);
    }

    @Override
    public void registerChannel(String name, MessageChannel channel) {
        if (!this.initialized) {
            this.initialize();
        }
        channel.setName(name);
        SubscriptionManager manager = new SubscriptionManager(channel, this.taskScheduler);
        this.subscriptionManagers.put(channel, manager);
        this.channelRegistry.registerChannel(name, channel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("registered channel '" + name + "'"));
        }
    }

    @Override
    public MessageChannel unregisterChannel(String name) {
        SubscriptionManager manager;
        MessageChannel removedChannel = this.channelRegistry.unregisterChannel(name);
        if (removedChannel != null && (manager = this.subscriptionManagers.remove(removedChannel)) != null && manager.isRunning()) {
            manager.stop();
        }
        return removedChannel;
    }

    public void registerHandler(String name, MessageHandler handler, Subscription subscription) {
        this.registerHandler(name, handler, subscription, this.defaultConcurrencyPolicy);
    }

    public void registerHandler(String name, MessageHandler handler, Subscription subscription, ConcurrencyPolicy concurrencyPolicy) {
        Assert.notNull((Object)handler, (String)"'handler' must not be null");
        HandlerEndpoint endpoint = new HandlerEndpoint(handler);
        this.doRegisterEndpoint(name, endpoint, subscription, concurrencyPolicy);
    }

    public void registerTarget(String name, Target target, Subscription subscription) {
        this.registerTarget(name, target, subscription, this.defaultConcurrencyPolicy);
    }

    public void registerTarget(String name, Target target, Subscription subscription, ConcurrencyPolicy concurrencyPolicy) {
        Assert.notNull((Object)target, (String)"'target' must not be null");
        TargetEndpoint endpoint = new TargetEndpoint(target);
        this.doRegisterEndpoint(name, endpoint, subscription, concurrencyPolicy);
    }

    private void doRegisterEndpoint(String name, TargetEndpoint endpoint, Subscription subscription, ConcurrencyPolicy concurrencyPolicy) {
        endpoint.setName(name);
        endpoint.setSubscription(subscription);
        endpoint.setConcurrencyPolicy(concurrencyPolicy);
        this.registerEndpoint(name, endpoint);
    }

    @Override
    public void registerEndpoint(String name, MessageEndpoint endpoint) {
        if (!this.initialized) {
            this.initialize();
        }
        if (endpoint instanceof ChannelRegistryAware) {
            ((ChannelRegistryAware)((Object)endpoint)).setChannelRegistry(this.channelRegistry);
        }
        if (endpoint instanceof TargetEndpoint) {
            this.registerTargetEndpoint(name, (TargetEndpoint)endpoint);
        } else if (endpoint instanceof SourceEndpoint) {
            this.registerSourceEndpoint(name, (SourceEndpoint)endpoint);
        }
        this.endpointRegistry.registerEndpoint(name, endpoint);
        if (this.isRunning()) {
            this.activateEndpoint(endpoint);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("registered endpoint '" + name + "'"));
        }
    }

    private void registerTargetEndpoint(String name, TargetEndpoint endpoint) {
        if (endpoint.getConcurrencyPolicy() == null && this.defaultConcurrencyPolicy != null) {
            endpoint.setConcurrencyPolicy(this.defaultConcurrencyPolicy);
        }
        endpoint.afterPropertiesSet();
    }

    @Override
    public MessageEndpoint unregisterEndpoint(String name) {
        MessageEndpoint endpoint = this.endpointRegistry.unregisterEndpoint(name);
        if (endpoint == null) {
            return null;
        }
        if (endpoint instanceof TargetEndpoint) {
            Collection<SubscriptionManager> managers = this.subscriptionManagers.values();
            boolean removed = false;
            for (SubscriptionManager manager : managers) {
                boolean bl = removed = removed || manager.removeTarget((TargetEndpoint)endpoint);
            }
            if (removed) {
                return endpoint;
            }
        }
        return null;
    }

    @Override
    public MessageEndpoint lookupEndpoint(String endpointName) {
        return this.endpointRegistry.lookupEndpoint(endpointName);
    }

    @Override
    public Set<String> getEndpointNames() {
        return this.endpointRegistry.getEndpointNames();
    }

    private void activateEndpoints() {
        Set<String> endpointNames = this.endpointRegistry.getEndpointNames();
        for (String name : endpointNames) {
            MessageEndpoint endpoint = this.endpointRegistry.lookupEndpoint(name);
            if (endpoint == null) continue;
            this.activateEndpoint(endpoint);
        }
    }

    private void activateEndpoint(MessageEndpoint endpoint) {
        if (endpoint instanceof TargetEndpoint) {
            this.activateTargetEndpoint((TargetEndpoint)endpoint);
        }
    }

    private void activateTargetEndpoint(TargetEndpoint endpoint) {
        TargetEndpoint targetEndpoint;
        HandlerEndpoint handlerEndpoint;
        String outputChannelName;
        Subscription subscription = endpoint.getSubscription();
        if (subscription == null) {
            throw new ConfigurationException("Unable to register endpoint '" + endpoint + "'. No subscription information is available.");
        }
        MessageChannel channel = subscription.getChannel();
        if (channel == null) {
            String channelName = subscription.getChannelName();
            if (channelName == null) {
                throw new ConfigurationException("endpoint '" + endpoint + "' must provide either 'channel' or 'channelName' in its subscription metadata");
            }
            channel = this.lookupChannel(channelName);
            if (channel == null) {
                if (!this.autoCreateChannels) {
                    throw new ConfigurationException("Cannot activate subscription, unknown channel '" + channelName + "'. Consider enabling the 'autoCreateChannels' option for the message bus.");
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("auto-creating channel '" + channelName + "'"));
                }
                channel = this.channelFactory.getChannel(null, null);
                this.registerChannel(channelName, channel);
            }
        }
        if (endpoint instanceof HandlerEndpoint && (outputChannelName = (handlerEndpoint = (HandlerEndpoint)endpoint).getOutputChannelName()) != null && this.lookupChannel(outputChannelName) == null) {
            if (!this.autoCreateChannels) {
                throw new ConfigurationException("Unknown channel '" + outputChannelName + "' configured as output channel for endpoint '" + endpoint + "'. Consider enabling the 'autoCreateChannels' option for the message bus.");
            }
            this.registerChannel(outputChannelName, new QueueChannel());
        }
        if (endpoint instanceof TargetEndpoint && !(targetEndpoint = endpoint).hasErrorHandler() && this.getErrorChannel() != null && !this.getErrorChannel().equals(channel)) {
            targetEndpoint.setErrorHandler(new MessagePublishingErrorHandler(this.getErrorChannel()));
        }
        this.activateSubscription(channel, endpoint, subscription.getSchedule());
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("activated subscription to channel '" + channel.getName() + "' for endpoint '" + endpoint + "'"));
        }
    }

    private void registerSourceEndpoint(String name, SourceEndpoint endpoint) {
        if (!this.initialized) {
            this.initialize();
        }
        if (endpoint instanceof MessagingTask) {
            this.taskScheduler.schedule((MessagingTask)((Object)endpoint));
        }
        if (endpoint instanceof Lifecycle) {
            this.lifecycleEndpoints.add((Lifecycle)endpoint);
            if (this.isRunning()) {
                ((Lifecycle)endpoint).start();
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("registered source adapter '" + name + "'"));
        }
    }

    private void activateSubscription(MessageChannel channel, Target target, Schedule schedule) {
        SubscriptionManager manager = this.subscriptionManagers.get(channel);
        if (manager == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("no subscription manager available for channel '" + channel + "', be sure to register the channel"));
            }
            return;
        }
        manager.addTarget(target, schedule);
        if (this.isRunning() && !manager.isRunning()) {
            manager.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.isRunning() || this.starting) {
            return;
        }
        this.starting = true;
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.activateEndpoints();
            this.taskScheduler.start();
            for (SubscriptionManager manager : this.subscriptionManagers.values()) {
                manager.start();
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("started subscription manager '" + manager + "'"));
            }
            for (Lifecycle endpoint : this.lifecycleEndpoints) {
                endpoint.start();
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("started endpoint '" + endpoint + "'"));
            }
        }
        this.running = true;
        this.starting = false;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"message bus started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.taskScheduler.stop();
            for (Lifecycle endpoint : this.lifecycleEndpoints) {
                endpoint.stop();
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("stopped endpoint '" + endpoint + "'"));
            }
            for (SubscriptionManager manager : this.subscriptionManagers.values()) {
                manager.stop();
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("stopped subscription manager '" + manager + "'"));
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"message bus stopped");
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ApplicationContext context = ((ContextRefreshedEvent)event).getApplicationContext();
            this.registerEndpoints(context);
            if (this.autoStartup) {
                this.start();
            }
        }
    }
}

