/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import org.springframework.util.Assert;

public class DispatcherPolicy {
    public static final int DEFAULT_MAX_MESSAGES_PER_TASK = 1;
    public static final long DEFAULT_RECEIVE_TIMEOUT = 1000L;
    public static final int DEFAULT_REJECTION_LIMIT = 5;
    public static final long DEFAULT_RETRY_INTERVAL = 1000L;
    private final boolean publishSubscribe;
    private volatile int maxMessagesPerTask = 1;
    private volatile long receiveTimeout = 1000L;
    private volatile int rejectionLimit = 5;
    private volatile long retryInterval = 1000L;
    private volatile boolean shouldFailOnRejectionLimit = true;

    public DispatcherPolicy() {
        this.publishSubscribe = false;
    }

    public DispatcherPolicy(boolean publishSubscribe) {
        this.publishSubscribe = publishSubscribe;
    }

    public boolean isPublishSubscribe() {
        return this.publishSubscribe;
    }

    public int getMaxMessagesPerTask() {
        return this.maxMessagesPerTask;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        Assert.isTrue((maxMessagesPerTask > 0 ? 1 : 0) != 0, (String)"'maxMessagePerTask' must be at least 1");
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getRejectionLimit() {
        return this.rejectionLimit;
    }

    public void setRejectionLimit(int rejectionLimit) {
        Assert.isTrue((rejectionLimit > 0 ? 1 : 0) != 0, (String)"'rejectionLimit' must be at least 1");
        this.rejectionLimit = rejectionLimit;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        Assert.isTrue((retryInterval >= 0L ? 1 : 0) != 0, (String)"'retryInterval' must not be negative");
        this.retryInterval = retryInterval;
    }

    public boolean getShouldFailOnRejectionLimit() {
        return this.shouldFailOnRejectionLimit;
    }

    public void setShouldFailOnRejectionLimit(boolean shouldFailOnRejectionLimit) {
        this.shouldFailOnRejectionLimit = shouldFailOnRejectionLimit;
    }
}

