/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessagePriority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityChannel
extends QueueChannel {
    private final Semaphore semaphore;

    public PriorityChannel(int capacity, DispatcherPolicy dispatcherPolicy, Comparator<Message<?>> comparator) {
        super(new PriorityBlockingQueue(capacity, comparator), dispatcherPolicy);
        this.semaphore = new Semaphore(capacity, true);
    }

    public PriorityChannel(int capacity, DispatcherPolicy dispatcherPolicy) {
        this(capacity, dispatcherPolicy, new MessagePriorityComparator());
    }

    public PriorityChannel(int capacity) {
        this(capacity, null, new MessagePriorityComparator());
    }

    public PriorityChannel() {
        this(100, null, new MessagePriorityComparator());
    }

    @Override
    protected boolean doSend(Message<?> message, long timeout) {
        try {
            if (!this.semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        return super.doSend(message, 0L);
    }

    @Override
    protected Message<?> doReceive(long timeout) {
        Message<?> message = super.doReceive(timeout);
        if (message != null) {
            this.semaphore.release();
            return message;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessagePriorityComparator
    implements Comparator<Message<?>> {
        private MessagePriorityComparator() {
        }

        @Override
        public int compare(Message<?> message1, Message<?> message2) {
            MessagePriority priority1 = message1.getHeader().getPriority();
            MessagePriority priority2 = message2.getHeader().getPriority();
            return priority1.compareTo(priority2);
        }
    }
}

