/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.List;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.bus.MessageBus;
import org.springframework.integration.bus.MessageBusAware;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.channel.RendezvousChannel;
import org.springframework.integration.endpoint.EndpointRegistry;
import org.springframework.integration.endpoint.HandlerEndpoint;
import org.springframework.integration.handler.ReplyHandler;
import org.springframework.integration.handler.ResponseCorrelator;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessagingException;
import org.springframework.integration.message.selector.MessageSelector;
import org.springframework.integration.scheduling.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestReplyTemplate
implements MessageBusAware {
    private MessageChannel requestChannel;
    private MessageChannel replyChannel;
    private volatile long requestTimeout = -1L;
    private volatile long replyTimeout = -1L;
    private ResponseCorrelator responseCorrelator;
    private EndpointRegistry endpointRegistry;
    private final Object responseCorrelatorMonitor = new Object();

    public RequestReplyTemplate(MessageChannel requestChannel, MessageChannel replyChannel) {
        this.requestChannel = requestChannel;
        this.replyChannel = replyChannel;
    }

    public RequestReplyTemplate(MessageChannel requestChannel) {
        this(requestChannel, null);
    }

    public RequestReplyTemplate() {
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.requestChannel = requestChannel;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.replyChannel = replyChannel;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public void setEndpointRegistry(EndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    @Override
    public void setMessageBus(MessageBus messageBus) {
        if (this.endpointRegistry == null) {
            this.setEndpointRegistry(messageBus);
        }
    }

    public boolean send(Message<?> message) {
        boolean sent;
        if (message == null) {
            throw new MessagingException("Message must not be null.");
        }
        if (this.requestChannel == null) {
            throw new MessagingException("No request channel has been configured. Cannot send message.");
        }
        boolean bl = sent = this.requestTimeout >= 0L ? this.requestChannel.send(message, this.requestTimeout) : this.requestChannel.send(message);
        if (!sent) {
            throw new MessagingException("Failed to send request message.");
        }
        return true;
    }

    public Message<?> receive() {
        if (this.replyChannel == null) {
            throw new MessagingException("No reply channel has been configured. Cannot perform receive only operation.");
        }
        return this.receiveResponse(this.replyChannel);
    }

    public boolean request(Message<?> message, ReplyHandler replyHandler) {
        ReplyHandlingChannelAdapter replyChannelAdapter = new ReplyHandlingChannelAdapter(message, replyHandler);
        message.getHeader().setReturnAddress(replyChannelAdapter);
        return this.send(message);
    }

    public Message<?> request(Message<?> message) {
        if (this.requestChannel == null) {
            throw new MessagingException("No request channel available. Cannot send request message.");
        }
        if (this.replyChannel != null) {
            return this.sendAndReceiveWithResponseCorrelator(message);
        }
        return this.sendAndReceiveWithTemporaryChannel(message);
    }

    private Message<?> sendAndReceiveWithResponseCorrelator(Message<?> message) {
        if (this.responseCorrelator == null) {
            this.registerResponseCorrelator();
        }
        message.getHeader().setReturnAddress(this.replyChannel);
        this.send(message);
        return this.replyTimeout >= 0L ? this.responseCorrelator.getResponse(message.getId(), this.replyTimeout) : this.responseCorrelator.getResponse(message.getId());
    }

    private Message<?> sendAndReceiveWithTemporaryChannel(Message<?> message) {
        RendezvousChannel temporaryChannel = new RendezvousChannel();
        message.getHeader().setReturnAddress(temporaryChannel);
        this.send(message);
        return this.receiveResponse(temporaryChannel);
    }

    private Message<?> receiveResponse(MessageChannel channel) {
        return this.replyTimeout >= 0L ? channel.receive(this.replyTimeout) : channel.receive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerResponseCorrelator() {
        Object object = this.responseCorrelatorMonitor;
        synchronized (object) {
            if (this.responseCorrelator != null) {
                return;
            }
            if (this.endpointRegistry == null) {
                throw new ConfigurationException("No EndpointRegistry available. Cannot register ResponseCorrelator.");
            }
            ResponseCorrelator correlator = new ResponseCorrelator(10);
            HandlerEndpoint endpoint = new HandlerEndpoint(correlator);
            endpoint.setSubscription(new Subscription(this.replyChannel));
            this.endpointRegistry.registerEndpoint("internal.correlator." + this, endpoint);
            this.responseCorrelator = correlator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReplyHandlingChannelAdapter
    implements MessageChannel {
        private final Message<?> originalMessage;
        private final ReplyHandler replyHandler;

        ReplyHandlingChannelAdapter(Message<?> originalMessage, ReplyHandler replyHandler) {
            this.originalMessage = originalMessage;
            this.replyHandler = replyHandler;
        }

        @Override
        public List<Message<?>> clear() {
            return null;
        }

        @Override
        public DispatcherPolicy getDispatcherPolicy() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public List<Message<?>> purge(MessageSelector selector) {
            return null;
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public Message receive() {
            return null;
        }

        public Message receive(long timeout) {
            return null;
        }

        @Override
        public boolean send(Message<?> message) {
            this.replyHandler.handle(message, this.originalMessage.getHeader());
            return true;
        }

        @Override
        public boolean send(Message<?> message, long timeout) {
            return this.send(message);
        }
    }
}

