/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.config.IntegrationNamespaceUtils;
import org.springframework.integration.endpoint.ConcurrencyPolicy;
import org.springframework.integration.scheduling.PollingSchedule;
import org.springframework.integration.scheduling.Schedule;
import org.springframework.integration.scheduling.Subscription;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTargetEndpointParser
extends AbstractSingleBeanDefinitionParser {
    private static final String INPUT_CHANNEL_ATTRIBUTE = "input-channel";
    private static final String SUBSCRIPTION_PROPERTY = "subscription";
    private static final String SELECTOR_ELEMENT = "selector";
    private static final String REF_ATTRIBUTE = "ref";
    private static final String SELECTORS_PROPERTY = "messageSelectors";
    private static final String ERROR_HANDLER_ATTRIBUTE = "error-handler";
    private static final String ERROR_HANDLER_PROPERTY = "errorHandler";
    private static final String PERIOD_ATTRIBUTE = "period";
    private static final String SCHEDULE_ELEMENT = "schedule";
    private static final String CONCURRENCY_ELEMENT = "concurrency";
    private static final String CONCURRENCY_POLICY_PROPERTY = "concurrencyPolicy";

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected abstract Class<?> getBeanClass(Element var1);

    protected abstract String getTargetAttributeName();

    protected abstract Class<?> getAdapterClass();

    protected void postProcess(BeanDefinitionBuilder builder, Element element) {
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String errorHandlerRef;
        this.parseTarget(element, this.getTargetAttributeName(), parserContext, builder);
        String inputChannel = element.getAttribute(INPUT_CHANNEL_ATTRIBUTE);
        Schedule schedule = null;
        ManagedList selectors = new ManagedList();
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1) {
                String localName = child.getLocalName();
                if (CONCURRENCY_ELEMENT.equals(localName)) {
                    this.parseConcurrencyPolicy((Element)child, builder);
                } else if (SELECTOR_ELEMENT.equals(localName)) {
                    String ref = ((Element)child).getAttribute(REF_ATTRIBUTE);
                    selectors.add((Object)new RuntimeBeanReference(ref));
                } else if (SCHEDULE_ELEMENT.equals(localName)) {
                    schedule = this.parseSchedule((Element)child);
                }
            }
            ++i;
        }
        if (StringUtils.hasText((String)inputChannel)) {
            RootBeanDefinition subscriptionDef = new RootBeanDefinition(Subscription.class);
            subscriptionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)inputChannel);
            if (schedule != null) {
                subscriptionDef.getConstructorArgumentValues().addGenericArgumentValue(schedule);
            }
            String subscriptionBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)subscriptionDef);
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)subscriptionDef, subscriptionBeanName));
            builder.addPropertyReference(SUBSCRIPTION_PROPERTY, subscriptionBeanName);
        }
        if (selectors.size() > 0) {
            builder.addPropertyValue(SELECTORS_PROPERTY, (Object)selectors);
        }
        if (StringUtils.hasText((String)(errorHandlerRef = element.getAttribute(ERROR_HANDLER_ATTRIBUTE)))) {
            builder.addPropertyReference(ERROR_HANDLER_PROPERTY, errorHandlerRef);
        }
        this.postProcess(builder, element);
    }

    private void parseTarget(Element element, String attribute, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String ref = element.getAttribute(attribute);
        if (!StringUtils.hasText((String)ref)) {
            throw new ConfigurationException("The '" + attribute + "' attribute is required.");
        }
        String method = element.getAttribute("method");
        if (StringUtils.hasText((String)method)) {
            String adapterBeanName = this.parseAdapter(ref, method, parserContext);
            builder.addConstructorArgReference(adapterBeanName);
        } else {
            builder.addConstructorArgReference(ref);
        }
    }

    private String parseAdapter(String ref, String method, ParserContext parserContext) {
        RootBeanDefinition adapterDef = new RootBeanDefinition(this.getAdapterClass());
        adapterDef.getPropertyValues().addPropertyValue("object", (Object)new RuntimeBeanReference(ref));
        adapterDef.getPropertyValues().addPropertyValue("methodName", (Object)method);
        String adapterBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)adapterDef);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)adapterDef, adapterBeanName));
        return adapterBeanName;
    }

    private void parseConcurrencyPolicy(Element concurrencyElement, BeanDefinitionBuilder builder) {
        ConcurrencyPolicy policy = IntegrationNamespaceUtils.parseConcurrencyPolicy(concurrencyElement);
        builder.addPropertyValue(CONCURRENCY_POLICY_PROPERTY, (Object)policy);
    }

    private Schedule parseSchedule(Element scheduleElement) {
        PollingSchedule schedule = new PollingSchedule(5L);
        String period = scheduleElement.getAttribute(PERIOD_ATTRIBUTE);
        if (StringUtils.hasText((String)period)) {
            schedule.setPeriod(Integer.parseInt(period));
        }
        return schedule;
    }
}

