/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.config.IntegrationNamespaceUtils;
import org.springframework.integration.router.AggregatingMessageHandler;
import org.springframework.integration.router.AggregatorAdapter;
import org.springframework.integration.router.CompletionStrategyAdapter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatorParser
implements BeanDefinitionParser {
    public static final String ID_ATTRIBUTE = "id";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String METHOD_ATTRIBUTE = "method";
    public static final String COMPLETION_STRATEGY_ATTRIBUTE = "completion-strategy";
    public static final String DEFAULT_REPLY_CHANNEL_ATTRIBUTE = "default-reply-channel";
    public static final String DISCARD_CHANNEL_ATTRIBUTE = "discard-channel";
    public static final String SEND_TIMEOUT_ATTRIBUTE = "send-timeout";
    public static final String SEND_PARTIAL_RESULT_ON_TIMEOUT_ATTRIBUTE = "send-partial-result-on-timeout";
    public static final String REAPER_INTERVAL_ATTRIBUTE = "reaper-interval";
    public static final String TRACKED_CORRELATION_ID_CAPACITY_ATTRIBUTE = "tracked-correlation-id-capacity";
    public static final String TIMEOUT_ATTRIBUTE = "timeout";
    private static final String COMPLETION_STRATEGY_PROPERTY = "completionStrategy";
    private static final String DEFAULT_REPLY_CHANNEL_PROPERTY = "defaultReplyChannel";
    private static final String DISCARD_CHANNEL_PROPERTY = "discardChannel";
    private static final String SEND_TIMEOUT_PROPERTY = "sendTimeout";
    private static final String SEND_PARTIAL_RESULT_ON_TIMEOUT_PROPERTY = "sendPartialResultOnTimeout";
    private static final String REAPER_INTERVAL_PROPERTY = "reaperInterval";
    public static final String TRACKED_CORRELATION_ID_CAPACITY_PROPERTY = "trackedCorrelationIdCapacity";
    public static final String TIMEOUT = "timeout";
    public static final String AGGREGATOR_ELEMENT = "aggregator";
    public static final String COMPLETION_STRATEGY_ELEMENT = "completion-strategy";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        return this.parseAggregatorElement(element, parserContext, true);
    }

    private BeanDefinition parseAggregatorElement(Element element, ParserContext parserContext, boolean topLevel) {
        RootBeanDefinition aggregatorDef = new RootBeanDefinition(AggregatingMessageHandler.class);
        aggregatorDef.setSource(parserContext.extractSource((Object)element));
        String id = element.getAttribute(ID_ATTRIBUTE);
        String ref = element.getAttribute(REF_ATTRIBUTE);
        String method = element.getAttribute(METHOD_ATTRIBUTE);
        String completionStrategyRef = element.getAttribute("completion-strategy");
        NodeList completionStrategyChildElements = element.getElementsByTagName("completion-strategy");
        if (!StringUtils.hasText((String)ref)) {
            throw new ConfigurationException("The 'ref' attribute must be present");
        }
        if (!topLevel && StringUtils.hasText((String)id)) {
            parserContext.getReaderContext().error("The 'id' attribute is only supported for top-level <aggregator> elements.", parserContext.extractSource((Object)element));
        }
        if (completionStrategyChildElements.getLength() > 0 && StringUtils.hasText((String)completionStrategyRef)) {
            parserContext.getReaderContext().error("The 'completion-strategy' element is only supported when no 'completion-strategy' attribute is specified.", parserContext.extractSource((Object)element));
        }
        if (!StringUtils.hasText((String)method)) {
            aggregatorDef.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(ref));
        } else {
            String adapterBeanName = this.createAdapterAndReturnBeanName(parserContext, ref, method, AggregatorAdapter.class);
            aggregatorDef.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(adapterBeanName));
        }
        if (StringUtils.hasText((String)completionStrategyRef)) {
            aggregatorDef.getPropertyValues().addPropertyValue(COMPLETION_STRATEGY_PROPERTY, (Object)new RuntimeBeanReference(completionStrategyRef));
        } else if (completionStrategyChildElements.getLength() > 0) {
            Element completionStrategyElement = (Element)completionStrategyChildElements.item(0);
            String childCompletionStrategyReference = completionStrategyElement.getAttribute(REF_ATTRIBUTE);
            String childCompletionStrategyMethod = completionStrategyElement.getAttribute(METHOD_ATTRIBUTE);
            String adapterBeanName = this.createAdapterAndReturnBeanName(parserContext, childCompletionStrategyReference, childCompletionStrategyMethod, CompletionStrategyAdapter.class);
            aggregatorDef.getPropertyValues().addPropertyValue(COMPLETION_STRATEGY_PROPERTY, (Object)new RuntimeBeanReference(adapterBeanName));
        }
        IntegrationNamespaceUtils.setBeanReferenceIfAttributeDefined(aggregatorDef, DEFAULT_REPLY_CHANNEL_PROPERTY, element, DEFAULT_REPLY_CHANNEL_ATTRIBUTE);
        IntegrationNamespaceUtils.setBeanReferenceIfAttributeDefined(aggregatorDef, DISCARD_CHANNEL_PROPERTY, element, DISCARD_CHANNEL_ATTRIBUTE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(aggregatorDef, SEND_TIMEOUT_PROPERTY, element, SEND_TIMEOUT_ATTRIBUTE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(aggregatorDef, SEND_PARTIAL_RESULT_ON_TIMEOUT_PROPERTY, element, SEND_PARTIAL_RESULT_ON_TIMEOUT_ATTRIBUTE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(aggregatorDef, REAPER_INTERVAL_PROPERTY, element, REAPER_INTERVAL_ATTRIBUTE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(aggregatorDef, TRACKED_CORRELATION_ID_CAPACITY_PROPERTY, element, TRACKED_CORRELATION_ID_CAPACITY_ATTRIBUTE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(aggregatorDef, "timeout", element, "timeout");
        String beanName = StringUtils.hasText((String)id) ? id : parserContext.getReaderContext().generateBeanName((BeanDefinition)aggregatorDef);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)aggregatorDef, beanName));
        return aggregatorDef;
    }

    private String createAdapterAndReturnBeanName(ParserContext parserContext, String ref, String method, Class<?> adapterClass) {
        RootBeanDefinition adapterDefinition = new RootBeanDefinition(adapterClass);
        adapterDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(ref));
        adapterDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)method);
        String adapterBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)adapterDefinition);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)adapterDefinition, adapterBeanName));
        return adapterBeanName;
    }
}

