/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.integration.config.AbstractTargetEndpointParser;
import org.springframework.integration.endpoint.HandlerEndpoint;
import org.springframework.integration.handler.DefaultMessageHandlerAdapter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerEndpointParser
extends AbstractTargetEndpointParser {
    private static final String OUTPUT_CHANNEL_ATTRIBUTE = "output-channel";
    private static final String OUTPUT_CHANNEL_PROPERTY = "outputChannelName";
    private static final String RETURN_ADDRESS_OVERRIDES_ATTRIBUTE = "return-address-overrides";
    private static final String REPLY_HANDLER_ATTRIBUTE = "reply-handler";
    private static final String REPLY_HANDLER_PROPERTY = "replyHandler";

    @Override
    protected Class<?> getBeanClass(Element element) {
        return HandlerEndpoint.class;
    }

    @Override
    protected String getTargetAttributeName() {
        return "handler";
    }

    @Override
    protected Class<?> getAdapterClass() {
        return DefaultMessageHandlerAdapter.class;
    }

    @Override
    protected void postProcess(BeanDefinitionBuilder builder, Element element) {
        String outputChannel = element.getAttribute(OUTPUT_CHANNEL_ATTRIBUTE);
        if (StringUtils.hasText((String)outputChannel)) {
            builder.addPropertyValue(OUTPUT_CHANNEL_PROPERTY, (Object)outputChannel);
        }
        String returnAddressOverridesAttribute = element.getAttribute(RETURN_ADDRESS_OVERRIDES_ATTRIBUTE);
        boolean returnAddressOverrides = "true".equals(returnAddressOverridesAttribute);
        builder.addPropertyValue("returnAddressOverrides", (Object)returnAddressOverrides);
        String replyHandler = element.getAttribute(REPLY_HANDLER_ATTRIBUTE);
        if (StringUtils.hasText((String)replyHandler)) {
            builder.addPropertyValue(REPLY_HANDLER_PROPERTY, (Object)new RuntimeBeanReference(replyHandler));
        }
    }
}

