/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.integration.channel.config.DirectChannelParser;
import org.springframework.integration.channel.config.PriorityChannelParser;
import org.springframework.integration.channel.config.QueueChannelParser;
import org.springframework.integration.channel.config.RendezvousChannelParser;
import org.springframework.integration.config.AggregatorParser;
import org.springframework.integration.config.AnnotationDrivenParser;
import org.springframework.integration.config.HandlerEndpointParser;
import org.springframework.integration.config.HandlerParser;
import org.springframework.integration.config.MessageBusParser;
import org.springframework.integration.config.MethodInvokingAdapterParser;
import org.springframework.integration.config.SourceEndpointParser;
import org.springframework.integration.config.TargetEndpointParser;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrationNamespaceHandler
extends NamespaceHandlerSupport {
    private static final String ADAPTER_PARSER_MAPPINGS_LOCATION = "META-INF/spring-integration.parsers";
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void init() {
        this.registerBeanDefinitionParser("message-bus", (BeanDefinitionParser)new MessageBusParser());
        this.registerBeanDefinitionParser("annotation-driven", new AnnotationDrivenParser());
        this.registerBeanDefinitionParser("channel", (BeanDefinitionParser)new QueueChannelParser());
        this.registerBeanDefinitionParser("direct-channel", (BeanDefinitionParser)new DirectChannelParser());
        this.registerBeanDefinitionParser("priority-channel", (BeanDefinitionParser)new PriorityChannelParser());
        this.registerBeanDefinitionParser("rendezvous-channel", (BeanDefinitionParser)new RendezvousChannelParser());
        this.registerBeanDefinitionParser("source-adapter", (BeanDefinitionParser)new MethodInvokingAdapterParser());
        this.registerBeanDefinitionParser("target-adapter", (BeanDefinitionParser)new MethodInvokingAdapterParser());
        this.registerBeanDefinitionParser("source-endpoint", (BeanDefinitionParser)new SourceEndpointParser());
        this.registerBeanDefinitionParser("handler-endpoint", (BeanDefinitionParser)new HandlerEndpointParser());
        this.registerBeanDefinitionParser("target-endpoint", (BeanDefinitionParser)new TargetEndpointParser());
        this.registerBeanDefinitionParser("handler", new HandlerParser());
        this.registerBeanDefinitionParser("handler-chain", new HandlerParser());
        this.registerBeanDefinitionParser("aggregator", new AggregatorParser());
        Map<String, Class<? extends BeanDefinitionParser>> parserMappings = this.loadAdapterParserMappings();
        try {
            for (Map.Entry<String, Class<? extends BeanDefinitionParser>> entry : parserMappings.entrySet()) {
                this.registerBeanDefinitionParser(entry.getKey(), entry.getValue().newInstance());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate BeanDefinitionParser.", e);
        }
    }

    private Map<String, Class<? extends BeanDefinitionParser>> loadAdapterParserMappings() {
        HashMap<String, Class<? extends BeanDefinitionParser>> parserMappings = new HashMap<String, Class<? extends BeanDefinitionParser>>();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            Properties mappings = PropertiesLoaderUtils.loadAllProperties((String)ADAPTER_PARSER_MAPPINGS_LOCATION, (ClassLoader)classLoader);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loaded parser mappings [" + mappings + "]"));
            }
            Enumeration<?> propertyNames = mappings.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                String classname = mappings.getProperty(name);
                Class parserClass = ClassUtils.forName((String)classname, (ClassLoader)classLoader);
                if (!BeanDefinitionParser.class.isAssignableFrom(parserClass)) {
                    throw new IllegalStateException("Expected class of type BeanDefinitionParser, but '" + name + "' was of type '" + parserClass.getSimpleName() + "'");
                }
                parserMappings.put(name, parserClass);
            }
            return parserMappings;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load BeanDefinitionParser mappings from location [META-INF/spring-integration.parsers]. Root cause: " + e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load BeanDefinitionParser.", e);
        }
    }
}

