/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.annotation.Subscriber;
import org.springframework.integration.bus.MessageBus;
import org.springframework.integration.handler.DefaultMessageHandlerAdapter;
import org.springframework.integration.scheduling.Subscription;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriberAnnotationPostProcessor
implements BeanPostProcessor {
    private Log logger = LogFactory.getLog(this.getClass());
    private Class<? extends Annotation> subscriberAnnotationType = Subscriber.class;
    private String channelNameAttribute = "channel";
    private MessageBus messageBus;

    public void setSubscriberAnnotationType(Class<? extends Annotation> subscriberAnnotationType) {
        Assert.notNull(subscriberAnnotationType, (String)"'subscriberAnnotationType' must not be null");
        this.subscriberAnnotationType = subscriberAnnotationType;
    }

    public void setChannelNameAttribute(String channelNameAttribute) {
        Assert.notNull((Object)channelNameAttribute, (String)"'channelNameAttribute' must not be null");
        this.channelNameAttribute = channelNameAttribute;
    }

    public void setMessageBus(MessageBus messageBus) {
        Assert.notNull((Object)messageBus, (String)"'messageBus' must not be null");
        this.messageBus = messageBus;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        final Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (targetClass == null) {
            return bean;
        }
        if (this.messageBus == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(String.valueOf(this.getClass().getSimpleName()) + " is disabled since no 'messageBus' was provided"));
            }
            return bean;
        }
        ReflectionUtils.doWithMethods((Class)targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Object annotation = method.getAnnotation(SubscriberAnnotationPostProcessor.this.subscriberAnnotationType);
                if (annotation != null) {
                    String channelName = (String)AnnotationUtils.getValue(annotation, (String)SubscriberAnnotationPostProcessor.this.channelNameAttribute);
                    DefaultMessageHandlerAdapter<Object> adapter = new DefaultMessageHandlerAdapter<Object>();
                    adapter.setMethodName(method.getName());
                    adapter.setObject(bean);
                    adapter.afterPropertiesSet();
                    String adapterName = String.valueOf(ClassUtils.getShortNameAsProperty((Class)targetClass)) + "-" + method.getName() + "-endpoint";
                    Subscription subscription = new Subscription(channelName);
                    SubscriberAnnotationPostProcessor.this.messageBus.registerHandler(adapterName, adapter, subscription);
                }
            }
        });
        return bean;
    }
}

