/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.List;
import org.springframework.integration.dispatcher.PollingDispatcher;
import org.springframework.integration.message.Message;
import org.springframework.integration.scheduling.MessagingTask;
import org.springframework.integration.scheduling.Schedule;
import org.springframework.util.Assert;

public class PollingDispatcherTask
implements MessagingTask {
    private final PollingDispatcher dispatcher;
    private final Schedule schedule;

    public PollingDispatcherTask(PollingDispatcher dispatcher, Schedule schedule) {
        Assert.notNull((Object)dispatcher, (String)"dispatcher must not be null");
        this.dispatcher = dispatcher;
        this.schedule = schedule;
    }

    public PollingDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void run() {
        List<Message<?>> messages = this.dispatcher.poll();
        for (Message<?> message : messages) {
            this.dispatcher.dispatch(message);
        }
    }
}

