/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.dispatcher.MessageDispatcher;
import org.springframework.integration.handler.MessageHandlerNotRunningException;
import org.springframework.integration.handler.MessageHandlerRejectedExecutionException;
import org.springframework.integration.message.BlockingTarget;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageDeliveryException;
import org.springframework.integration.message.Subscribable;
import org.springframework.integration.message.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDispatcher
implements MessageDispatcher,
Subscribable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final List<Target> targets = new CopyOnWriteArrayList<Target>();
    protected final DispatcherPolicy dispatcherPolicy;
    private volatile long sendTimeout;

    public SimpleDispatcher(DispatcherPolicy dispatcherPolicy) {
        this.dispatcherPolicy = dispatcherPolicy != null ? dispatcherPolicy : new DispatcherPolicy();
    }

    @Override
    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    @Override
    public boolean subscribe(Target target) {
        return this.targets.add(target);
    }

    @Override
    public boolean unsubscribe(Target target) {
        return this.targets.remove(target);
    }

    @Override
    public boolean dispatch(Message<?> message) {
        int attempts = 0;
        ArrayList<Target> targetList = new ArrayList<Target>(this.targets);
        while (attempts < this.dispatcherPolicy.getRejectionLimit()) {
            Iterator iter;
            if (attempts > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("target(s) rejected message after " + attempts + " attempt(s), will try again after 'retryInterval' of " + this.dispatcherPolicy.getRetryInterval() + " milliseconds"));
                }
                try {
                    Thread.sleep(this.dispatcherPolicy.getRetryInterval());
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            if (!(iter = targetList.iterator()).hasNext()) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"no active targets");
                }
                return false;
            }
            boolean rejected = false;
            while (iter.hasNext()) {
                boolean sent;
                block15: {
                    Target target = (Target)iter.next();
                    boolean bl = sent = target instanceof BlockingTarget && this.sendTimeout >= 0L ? ((BlockingTarget)target).send(message, this.sendTimeout) : target.send(message);
                    if (this.dispatcherPolicy.isPublishSubscribe() || !sent) break block15;
                    return true;
                }
                try {
                    if (!sent && this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"target rejected message, continuing with other targets if available");
                    }
                    iter.remove();
                }
                catch (MessageHandlerNotRunningException e) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)"target is not running, continuing with other targets if available", (Throwable)e);
                }
                catch (MessageHandlerRejectedExecutionException e) {
                    rejected = true;
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)"target is busy, continuing with other targets if available", (Throwable)e);
                }
            }
            if (!rejected) {
                return true;
            }
            ++attempts;
        }
        if (this.dispatcherPolicy.getShouldFailOnRejectionLimit()) {
            throw new MessageDeliveryException(message, "Dispatcher reached rejection limit of " + this.dispatcherPolicy.getRejectionLimit() + ". Consider increasing the target's concurrency and/or " + "the dispatcherPolicy's 'rejectionLimit'.");
        }
        return false;
    }
}

