/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.DispatcherPolicy;
import org.springframework.integration.dispatcher.SimpleDispatcher;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.Source;
import org.springframework.integration.message.Subscribable;
import org.springframework.integration.message.Target;
import org.springframework.integration.message.selector.MessageSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousChannel
extends AbstractMessageChannel
implements Subscribable {
    private static final ThreadLocalMessageHolder messageHolder = new ThreadLocalMessageHolder();
    private volatile Source<?> source;
    private final SimpleDispatcher dispatcher;
    private final AtomicInteger handlerCount = new AtomicInteger();

    public SynchronousChannel() {
        this((Source<?>)null);
    }

    public SynchronousChannel(Source<?> source) {
        super(SynchronousChannel.defaultDispatcherPolicy());
        this.source = source;
        this.dispatcher = new SimpleDispatcher(this.getDispatcherPolicy());
    }

    public void setSource(Source<?> source) {
        this.source = source;
    }

    @Override
    public boolean subscribe(Target target) {
        boolean added = this.dispatcher.subscribe(target);
        if (added) {
            this.handlerCount.incrementAndGet();
        }
        return added;
    }

    @Override
    public boolean unsubscribe(Target target) {
        boolean removed = this.dispatcher.unsubscribe(target);
        if (removed) {
            this.handlerCount.decrementAndGet();
        }
        return removed;
    }

    @Override
    protected Message<?> doReceive(long timeout) {
        Message<?> result;
        if (this.source != null && (result = this.source.receive()) != null) {
            return result;
        }
        return (Message)((Queue)messageHolder.get()).poll();
    }

    @Override
    protected boolean doSend(Message<?> message, long timeout) {
        if (message == null) {
            return false;
        }
        if (this.handlerCount.get() > 0) {
            return this.dispatcher.dispatch(message);
        }
        if (this.source == null) {
            return ((Queue)messageHolder.get()).add(message);
        }
        return false;
    }

    @Override
    public List<Message<?>> clear() {
        ArrayList removedMessages = new ArrayList();
        Message next = (Message)((Queue)messageHolder.get()).poll();
        while (next != null) {
            removedMessages.add(next);
            next = (Message)((Queue)messageHolder.get()).poll();
        }
        return removedMessages;
    }

    @Override
    public List<Message<?>> purge(MessageSelector selector) {
        Object[] allMessages;
        ArrayList removedMessages = new ArrayList();
        Object[] objectArray = allMessages = ((Queue)messageHolder.get()).toArray();
        int n = allMessages.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            Message message = (Message)next;
            if (!selector.accept(message) && ((Queue)messageHolder.get()).remove(message)) {
                removedMessages.add(message);
            }
            ++n2;
        }
        return removedMessages;
    }

    private static DispatcherPolicy defaultDispatcherPolicy() {
        DispatcherPolicy dispatcherPolicy = new DispatcherPolicy(false);
        dispatcherPolicy.setMaxMessagesPerTask(1);
        dispatcherPolicy.setReceiveTimeout(0L);
        dispatcherPolicy.setRejectionLimit(1);
        dispatcherPolicy.setRetryInterval(0L);
        dispatcherPolicy.setShouldFailOnRejectionLimit(false);
        return dispatcherPolicy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalMessageHolder
    extends ThreadLocal<Queue<Message<?>>> {
        private ThreadLocalMessageHolder() {
        }

        @Override
        protected Queue<Message<?>> initialValue() {
            return new LinkedBlockingQueue();
        }
    }
}

