/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.integration.endpoint.EndpointPolicy;
import org.springframework.util.Assert;

public class ConcurrencyPolicy
implements EndpointPolicy {
    public static final int DEFAULT_CORE_SIZE = 1;
    public static final int DEFAULT_MAX_SIZE = 10;
    public static final int DEFAULT_QUEUE_CAPACITY = 0;
    public static final int DEFAULT_KEEP_ALIVE_SECONDS = 60;
    private int coreSize = 1;
    private int maxSize = 10;
    private int queueCapacity = 0;
    private int keepAliveSeconds = 60;

    public ConcurrencyPolicy() {
    }

    public ConcurrencyPolicy(int coreSize, int maxSize) {
        Assert.isTrue((maxSize >= coreSize ? 1 : 0) != 0, (String)"'coreSize' must not exceed 'maxSize'");
        this.setCoreSize(coreSize);
        this.setMaxSize(maxSize);
    }

    public int getCoreSize() {
        return this.coreSize;
    }

    public void setCoreSize(int coreSize) {
        Assert.isTrue((coreSize > 0 ? 1 : 0) != 0, (String)"'coreSize' must be at least 1");
        this.coreSize = coreSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        Assert.isTrue((maxSize > 0 ? 1 : 0) != 0, (String)"'maxSize' must be at least 1");
        this.maxSize = maxSize;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public void setQueueCapacity(int queueCapacity) {
        Assert.isTrue((queueCapacity >= 0 ? 1 : 0) != 0, (String)"'queueCapacity' must not be negative");
        this.queueCapacity = queueCapacity;
    }

    public int getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        Assert.isTrue((keepAliveSeconds >= 0 ? 1 : 0) != 0, (String)"'keepAliveSeconds' must not be negative");
        this.keepAliveSeconds = keepAliveSeconds;
    }

    public String toString() {
        return "[coreSize=" + this.coreSize + ", maxSize=" + this.maxSize + ", queueCapacity=" + this.queueCapacity + ", keepAliveSeconds=" + this.keepAliveSeconds + "]";
    }
}

