/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.integration.endpoint.EndpointRegistry;
import org.springframework.integration.endpoint.MessageEndpoint;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEndpointRegistry
implements EndpointRegistry {
    private final Map<String, MessageEndpoint> endpoints = new ConcurrentHashMap<String, MessageEndpoint>();

    @Override
    public MessageEndpoint lookupEndpoint(String endpointName) {
        return this.endpoints.get(endpointName);
    }

    @Override
    public void registerEndpoint(String name, MessageEndpoint endpoint) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        Assert.notNull((Object)endpoint, (String)"'endpoint' must not be null");
        this.endpoints.put(name, endpoint);
    }

    @Override
    public MessageEndpoint unregisterEndpoint(String name) {
        return name != null ? this.endpoints.remove(name) : null;
    }

    @Override
    public Set<String> getEndpointNames() {
        return this.endpoints.keySet();
    }
}

