/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.channel.RequestReplyTemplate;
import org.springframework.integration.message.DefaultMessageCreator;
import org.springframework.integration.message.DefaultMessageMapper;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageCreator;
import org.springframework.integration.message.MessageMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagingGateway {
    private final RequestReplyTemplate requestReplyTemplate = new RequestReplyTemplate();
    private MessageCreator messageCreator = new DefaultMessageCreator();
    private MessageMapper messageMapper = new DefaultMessageMapper();

    public MessagingGateway(MessageChannel requestChannel) {
        this.requestReplyTemplate.setRequestChannel(requestChannel);
    }

    public MessagingGateway() {
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.requestReplyTemplate.setRequestChannel(requestChannel);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.requestReplyTemplate.setReplyChannel(replyChannel);
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestReplyTemplate.setRequestTimeout(requestTimeout);
    }

    public void setReplyTimeout(long replyTimeout) {
        this.requestReplyTemplate.setReplyTimeout(replyTimeout);
    }

    public void setMessageCreator(MessageCreator<?, ?> messageCreator) {
        Assert.notNull(messageCreator, (String)"messageCreator must not be null");
        this.messageCreator = messageCreator;
    }

    public void setMessageMapper(MessageMapper<?, ?> messageMapper) {
        Assert.notNull(messageMapper, (String)"messageMapper must not be null");
        this.messageMapper = messageMapper;
    }

    protected RequestReplyTemplate getRequestReplyTemplate() {
        return this.requestReplyTemplate;
    }

    public void send(Object object) {
        Message message;
        Message message2 = message = object instanceof Message ? (Message)object : this.messageCreator.createMessage(object);
        if (message != null) {
            this.requestReplyTemplate.send(message);
        }
    }

    public Object receive() {
        Message<?> message = this.requestReplyTemplate.receive();
        return message != null ? this.messageMapper.mapMessage(message) : null;
    }

    public Object sendAndReceive(Object object) {
        return this.sendAndReceive(object, true);
    }

    public Message<?> sendAndReceiveMessage(Object object) {
        return (Message)this.sendAndReceive(object, false);
    }

    private Object sendAndReceive(Object object, boolean shouldMapMessage) {
        Message request;
        Message message = request = object instanceof Message ? (Message)object : this.messageCreator.createMessage(object);
        if (request == null) {
            return null;
        }
        Message<?> reply = this.requestReplyTemplate.request(request);
        if (!shouldMapMessage) {
            return reply;
        }
        return reply != null ? this.messageMapper.mapMessage(reply) : null;
    }
}

