/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.integration.handler.HandlerMethodInvoker;
import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.message.GenericMessage;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageHeader;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageHandlerAdapter<T>
implements MessageHandler,
Ordered,
InitializingBean {
    public static final String OUTPUT_CHANNEL_NAME_KEY = "outputChannelName";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile T object;
    private volatile String methodName;
    private volatile HandlerMethodInvoker<T> invoker;
    private volatile int order = Integer.MAX_VALUE;
    private volatile boolean initialized;
    private final Object lifecycleMonitor = new Object();

    public void setObject(T object) {
        Assert.notNull(object, (String)"'object' must not be null");
        this.object = object;
    }

    protected Object getObject() {
        return this.object;
    }

    public void setMethodName(String methodName) {
        Assert.notNull((Object)methodName, (String)"'methodName' must not be null");
        this.methodName = methodName;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void afterPropertiesSet() {
        this.validate();
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.invoker = new HandlerMethodInvoker<T>(this.object, this.methodName);
            this.initialized = true;
        }
        this.initialize();
    }

    @Override
    public final Message<?> handle(Message<?> message) {
        Object result;
        if (!this.initialized) {
            this.afterPropertiesSet();
        }
        if ((result = this.doHandle(message, this.invoker)) != null) {
            Message<?> reply = result instanceof Message ? (Message<?>)result : this.createReplyMessage(result, message.getHeader());
            Object correlationId = reply.getHeader().getCorrelationId();
            if (correlationId == null) {
                Object orginalCorrelationId = message.getHeader().getCorrelationId();
                reply.getHeader().setCorrelationId(orginalCorrelationId != null ? orginalCorrelationId : message.getId());
            }
            return reply;
        }
        return null;
    }

    protected void validate() {
    }

    protected void initialize() {
    }

    protected Message<?> createReplyMessage(Object payload, MessageHeader originalMessageHeader) {
        return new GenericMessage<Object>(payload, originalMessageHeader);
    }

    protected abstract Object doHandle(Message<?> var1, HandlerMethodInvoker<T> var2);
}

