/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.lang.reflect.InvocationTargetException;
import org.springframework.beans.support.ArgumentConvertingMethodInvoker;
import org.springframework.integration.message.MessagingException;
import org.springframework.integration.util.MethodValidator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerMethodInvoker<T> {
    private T object;
    private String method;
    private MethodValidator methodValidator;

    public HandlerMethodInvoker(T object, String method) {
        Assert.notNull(object, (String)"'object' must not be null");
        Assert.notNull((Object)method, (String)"'method' must not be null");
        this.object = object;
        this.method = method;
    }

    public void setMethodValidator(MethodValidator methodValidator) {
        this.methodValidator = methodValidator;
    }

    public Object invokeMethod(Object ... args) {
        try {
            ArgumentConvertingMethodInvoker methodInvoker = new ArgumentConvertingMethodInvoker();
            methodInvoker.setTargetObject(this.object);
            methodInvoker.setTargetMethod(this.method);
            methodInvoker.setArguments(args);
            methodInvoker.prepare();
            methodInvoker.getPreparedMethod().setAccessible(true);
            if (this.methodValidator != null) {
                this.methodValidator.validate(methodInvoker.getPreparedMethod());
            }
            return methodInvoker.invoke();
        }
        catch (InvocationTargetException e) {
            throw new MessagingException("Method '" + this.method + "' threw an Exception.", e.getTargetException());
        }
        catch (Throwable e) {
            throw new MessagingException("Failed to invoke method '" + this.method + "' with arguments: " + ObjectUtils.nullSafeToString((Object[])args), e);
        }
    }
}

